/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.AbstractDistanceCalculator;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;

class RoundingDistCalc
extends AbstractDistanceCalculator {
    DistanceCalculator delegate;

    RoundingDistCalc(DistanceCalculator delegate) {
        this.delegate = delegate;
    }

    double round(double val) {
        double scale = Math.pow(10.0, 10.0);
        return (double)Math.round(val * scale) / scale;
    }

    public double distance(Point from, double toX, double toY) {
        return this.round(this.delegate.distance(from, toX, toY));
    }

    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        return this.delegate.pointOnBearing(from, distDEG, bearingDEG, ctx, reuse);
    }

    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        return this.delegate.calcBoxByDistFromPt(from, distDEG, ctx, reuse);
    }

    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        return this.delegate.calcBoxByDistFromPt_yHorizAxisDEG(from, distDEG, ctx);
    }

    public double area(Rectangle rect) {
        return this.delegate.area(rect);
    }

    public double area(Circle circle) {
        return this.delegate.area(circle);
    }
}

