/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;

public abstract class RandomizedShapeTest
extends RandomizedTest {
    protected static final double EPS = 1.0E-8;
    protected SpatialContext ctx;
    protected final double DIVISIBLE = 2.0;

    protected RandomizedShapeTest() {
    }

    public RandomizedShapeTest(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public static void checkShapesImplementEquals(Class[] classes) {
        for (Class clazz : classes) {
            try {
                clazz.getDeclaredMethod("equals", Object.class);
            }
            catch (Exception e) {
                RandomizedShapeTest.fail((String)("Shape needs to define 'equals' : " + clazz.getName()));
            }
            try {
                clazz.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Exception e) {
                RandomizedShapeTest.fail((String)("Shape needs to define 'hashCode' : " + clazz.getName()));
            }
        }
    }

    protected double normX(double x) {
        return this.ctx.isGeo() ? DistanceUtils.normLonDEG((double)x) : x;
    }

    protected double normY(double y) {
        return this.ctx.isGeo() ? DistanceUtils.normLatDEG((double)y) : y;
    }

    protected Rectangle makeNormRect(double minX, double maxX, double minY, double maxY) {
        double t;
        if (this.ctx.isGeo()) {
            if (Math.abs(maxX - minX) >= 360.0) {
                minX = -180.0;
                maxX = 180.0;
            } else {
                minX = DistanceUtils.normLonDEG((double)minX);
                maxX = DistanceUtils.normLonDEG((double)maxX);
            }
        } else {
            if (maxX < minX) {
                t = minX;
                minX = maxX;
                maxX = t;
            }
            minX = RandomizedShapeTest.boundX(minX, this.ctx.getWorldBounds());
            maxX = RandomizedShapeTest.boundX(maxX, this.ctx.getWorldBounds());
        }
        if (maxY < minY) {
            t = minY;
            minY = maxY;
            maxY = t;
        }
        minY = RandomizedShapeTest.boundY(minY, this.ctx.getWorldBounds());
        maxY = RandomizedShapeTest.boundY(maxY, this.ctx.getWorldBounds());
        return this.ctx.makeRectangle(minX, maxX, minY, maxY);
    }

    public static double divisible(double v, double divisible) {
        return (int)((double)Math.round(v / divisible) * divisible);
    }

    protected double divisible(double v) {
        return RandomizedShapeTest.divisible(v, 2.0);
    }

    protected Point divisible(Point p) {
        Rectangle bounds = this.ctx.getWorldBounds();
        double newX = RandomizedShapeTest.boundX(this.divisible(p.getX()), bounds);
        double newY = RandomizedShapeTest.boundY(this.divisible(p.getY()), bounds);
        p.reset(newX, newY);
        return p;
    }

    static double boundX(double i, Rectangle bounds) {
        return RandomizedShapeTest.bound(i, bounds.getMinX(), bounds.getMaxX());
    }

    static double boundY(double i, Rectangle bounds) {
        return RandomizedShapeTest.bound(i, bounds.getMinY(), bounds.getMaxY());
    }

    static double bound(double i, double min, double max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    protected void assertRelation(SpatialRelation expected, Shape a, Shape b) {
        this.assertRelation(null, expected, a, b);
    }

    protected void assertRelation(String msg, SpatialRelation expected, Shape a, Shape b) {
        this._assertIntersect(msg, expected, a, b);
        this._assertIntersect(msg, expected.transpose(), b, a);
    }

    private void _assertIntersect(String msg, SpatialRelation expected, Shape a, Shape b) {
        SpatialRelation sect = a.relate(b);
        if (sect == expected) {
            return;
        }
        msg = (msg == null ? "" : msg + "\r") + a + " intersect " + b;
        if (expected == SpatialRelation.WITHIN || expected == SpatialRelation.CONTAINS) {
            if (a.getClass().equals(b.getClass())) {
                RandomizedShapeTest.assertEquals((String)msg, (Object)a, (Object)b);
            } else {
                RandomizedShapeTest.assertTrue((String)msg, (!a.hasArea() ? 1 : 0) != 0);
                RandomizedShapeTest.assertTrue((String)msg, (!b.hasArea() ? 1 : 0) != 0);
                Rectangle aBBox = a.getBoundingBox();
                Rectangle bBBox = b.getBoundingBox();
                if (aBBox.getHeight() != 0.0 || bBBox.getHeight() != 0.0 || (aBBox.getMaxY() != 90.0 || bBBox.getMaxY() != 90.0) && (aBBox.getMinY() != -90.0 || bBBox.getMinY() != -90.0)) {
                    RandomizedShapeTest.assertEquals((String)msg, (Object)aBBox, (Object)bBBox);
                }
            }
        } else {
            RandomizedShapeTest.assertEquals((String)msg, (Object)expected, (Object)sect);
        }
    }

    protected void assertEqualsRatio(String msg, double expected, double actual) {
        double delta = Math.abs(actual - expected);
        double base = Math.min(actual, expected);
        double deltaRatio = base == 0.0 ? delta : Math.min(delta, delta / base);
        RandomizedShapeTest.assertEquals((String)msg, (double)0.0, (double)deltaRatio, (double)1.0E-8);
    }

    protected int randomIntBetweenDivisible(int start, int end) {
        return this.randomIntBetweenDivisible(start, end, 2);
    }

    protected int randomIntBetweenDivisible(int start, int end, int divisible) {
        int divisStart = (int)Math.ceil((double)(start + 1) / (double)divisible);
        int divisEnd = (int)Math.floor((double)(end - 1) / (double)divisible);
        int divisRange = Math.max(0, divisEnd - divisStart + 1);
        int r = RandomizedShapeTest.randomInt((int)(1 + divisRange));
        if (r == 0) {
            return start;
        }
        if (r == 1) {
            return end;
        }
        return (r - 2 + divisStart) * divisible;
    }

    protected Rectangle randomRectangle(Point nearP) {
        Rectangle bounds = this.ctx.getWorldBounds();
        if (nearP == null) {
            nearP = this.randomPointIn(bounds);
        }
        double[] worldXRange = new double[]{bounds.getMinX(), bounds.getMaxX()};
        double[] worldYRange = new double[]{bounds.getMinY(), bounds.getMaxY()};
        double[] xRange = this.randomRange(RandomizedShapeTest.rarely() ? 0.0 : nearP.getX(), worldXRange);
        double[] yRange = this.randomRange(RandomizedShapeTest.rarely() ? 0.0 : nearP.getY(), worldYRange);
        return this.makeNormRect(this.divisible(xRange[0]), this.divisible(xRange[1]), this.divisible(yRange[0]), this.divisible(yRange[1]));
    }

    private double[] randomRange(double near, double[] bounds) {
        double boundsWidth = bounds[1] - bounds[0];
        double mid = near + RandomizedShapeTest.randomGaussian() * boundsWidth / 6.0;
        double width = Math.abs(RandomizedShapeTest.randomGaussian()) * boundsWidth / 6.0;
        return new double[]{mid - width / 2.0, mid + width / 2.0};
    }

    private double randomGaussianZeroTo(double max) {
        double r;
        if (max == 0.0) {
            return max;
        }
        assert (max > 0.0);
        while ((r = Math.abs(RandomizedShapeTest.randomGaussian()) * (max * 0.5)) > max) {
        }
        return r;
    }

    protected Rectangle randomRectangle(int divisible) {
        double rX = this.randomIntBetweenDivisible(-180, 180, divisible);
        double rW = this.randomIntBetweenDivisible(0, 360, divisible);
        double rY1 = this.randomIntBetweenDivisible(-90, 90, divisible);
        double rY2 = this.randomIntBetweenDivisible(-90, 90, divisible);
        double rYmin = Math.min(rY1, rY2);
        double rYmax = Math.max(rY1, rY2);
        if (rW > 0.0 && rX == 180.0) {
            rX = -180.0;
        }
        return this.makeNormRect(rX, rX + rW, rYmin, rYmax);
    }

    protected Point randomPoint() {
        return this.randomPointIn(this.ctx.getWorldBounds());
    }

    protected Point randomPointIn(Circle c) {
        double d = c.getRadius() * RandomizedShapeTest.randomDouble();
        double angleDEG = 360.0 * RandomizedShapeTest.randomDouble();
        Point p = this.ctx.getDistCalc().pointOnBearing(c.getCenter(), d, angleDEG, this.ctx, null);
        RandomizedShapeTest.assertEquals((Object)SpatialRelation.CONTAINS, (Object)c.relate((Shape)p));
        return p;
    }

    protected Point randomPointIn(Rectangle r) {
        double x = r.getMinX() + RandomizedShapeTest.randomDouble() * r.getWidth();
        double y = r.getMinY() + RandomizedShapeTest.randomDouble() * r.getHeight();
        x = this.normX(x);
        y = this.normY(y);
        Point p = this.ctx.makePoint(x, y);
        RandomizedShapeTest.assertEquals((Object)SpatialRelation.CONTAINS, (Object)r.relate((Shape)p));
        return p;
    }

    protected Point randomPointIn(Shape shape) {
        Point p;
        if (!shape.hasArea()) {
            throw new UnsupportedOperationException("Need area to define shape!");
        }
        Rectangle bbox = shape.getBoundingBox();
        while (!shape.relate((Shape)(p = this.randomPointIn(bbox))).intersects()) {
        }
        return p;
    }

    protected Point randomPointInOrNull(Shape shape) {
        if (!shape.hasArea()) {
            throw new UnsupportedOperationException("Need area to define shape!");
        }
        Rectangle bbox = shape.getBoundingBox();
        for (int i = 0; i < 1000; ++i) {
            Point p = this.randomPointIn(bbox);
            if (!shape.relate((Shape)p).intersects()) continue;
            return p;
        }
        return null;
    }

    public static void assertGreaterOrEqual(double left, double right, double delta) {
        if (left > right) {
            return;
        }
        RandomizedShapeTest.assertEquals((double)left, (double)right, (double)delta);
    }
}

