/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.spatial4j.core.TestLog;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.RectIntersectionTestHelper;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.impl.BufferedLine;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Rule;
import org.junit.Test;

public class BufferedLineTest
extends RandomizedTest {
    private final SpatialContext ctx = new SpatialContextFactory(){
        {
            this.geo = false;
            this.worldBounds = new RectangleImpl(-100.0, 100.0, -50.0, 50.0, null);
        }
    }.newSpatialContext();
    @Rule
    public TestLog testLog = TestLog.instance;

    public static void logShapes(BufferedLine line, Rectangle rect) {
        String lineWKT = "LINESTRING(" + line.getA().getX() + " " + line.getA().getY() + "," + line.getB().getX() + " " + line.getB().getY() + ")";
        System.out.println("GEOMETRYCOLLECTION(" + lineWKT + "," + BufferedLineTest.rectToWkt(line.getBoundingBox()) + ")");
        String rectWKT = BufferedLineTest.rectToWkt(rect);
        System.out.println(rectWKT);
    }

    private static String rectToWkt(Rectangle rect) {
        return "POLYGON((" + rect.getMinX() + " " + rect.getMinY() + "," + rect.getMaxX() + " " + rect.getMinY() + "," + rect.getMaxX() + " " + rect.getMaxY() + "," + rect.getMinX() + " " + rect.getMaxY() + "," + rect.getMinX() + " " + rect.getMinY() + "))";
    }

    @Test
    public void distance() {
        this.testDistToPoint(this.ctx.makePoint(7.0, -4.0), this.ctx.makePoint(3.0, 2.0), this.ctx.makePoint(5.0, 6.0), 3.8829);
        this.testDistToPoint(this.ctx.makePoint(3.0, 2.0), this.ctx.makePoint(7.0, 5.0), this.ctx.makePoint(5.0, 6.0), 2.0);
        this.testDistToPoint(this.ctx.makePoint(3.0, 2.0), this.ctx.makePoint(3.0, 8.0), this.ctx.makePoint(4.0, 3.0), 1.0);
        this.testDistToPoint(this.ctx.makePoint(3.0, 2.0), this.ctx.makePoint(6.0, 2.0), this.ctx.makePoint(4.0, 3.0), 1.0);
    }

    private void testDistToPoint(Point pA, Point pB, Point pC, double dist) {
        if (dist > 0.0) {
            BufferedLineTest.assertFalse((boolean)new BufferedLine(pA, pB, dist * 0.999, this.ctx).contains(pC));
        } else {
            assert (dist == 0.0);
            BufferedLineTest.assertTrue((boolean)new BufferedLine(pA, pB, 0.0, this.ctx).contains(pC));
        }
        BufferedLineTest.assertTrue((boolean)new BufferedLine(pA, pB, dist * 1.001, this.ctx).contains(pC));
    }

    @Test
    public void misc() {
        Point pt = this.ctx.makePoint(10.0, 1.0);
        BufferedLine line = new BufferedLine(pt, pt, 3.0, this.ctx);
        BufferedLineTest.assertTrue((boolean)line.contains(this.ctx.makePoint(10.0, 3.9)));
        BufferedLineTest.assertFalse((boolean)line.contains(this.ctx.makePoint(10.0, 4.1)));
    }

    @Test
    @Repeat(iterations=15)
    public void quadrants() {
        BufferedLine line = this.newRandomLine();
        Rectangle rect = this.newRandomLine().getBoundingBox();
        ArrayList<Point> corners = this.quadrantCorners(rect);
        LinkedList<Integer> farthestDistanceQuads = new LinkedList<Integer>();
        double farthestDistance = -1.0;
        int quad = 1;
        for (Point corner : corners) {
            double d = line.getLinePrimary().distanceUnbuffered(corner);
            if (Math.abs(d - farthestDistance) < 1.0E-6) {
                farthestDistanceQuads.add(quad);
            } else if (d > farthestDistance) {
                farthestDistanceQuads.clear();
                farthestDistanceQuads.add(quad);
                farthestDistance = d;
            }
            ++quad;
        }
        int calcClosestQuad = line.getLinePrimary().quadrant(rect.getCenter());
        BufferedLineTest.assertTrue((boolean)farthestDistanceQuads.contains(calcClosestQuad));
    }

    private BufferedLine newRandomLine() {
        PointImpl pA = new PointImpl((double)BufferedLineTest.randomInt((int)9), (double)BufferedLineTest.randomInt((int)9), this.ctx);
        PointImpl pB = new PointImpl((double)BufferedLineTest.randomInt((int)9), (double)BufferedLineTest.randomInt((int)9), this.ctx);
        int buf = BufferedLineTest.randomInt((int)5);
        return new BufferedLine((Point)pA, (Point)pB, (double)buf, this.ctx);
    }

    private ArrayList<Point> quadrantCorners(Rectangle rect) {
        ArrayList<Point> corners = new ArrayList<Point>(4);
        corners.add(this.ctx.makePoint(rect.getMaxX(), rect.getMaxY()));
        corners.add(this.ctx.makePoint(rect.getMinX(), rect.getMaxY()));
        corners.add(this.ctx.makePoint(rect.getMinX(), rect.getMinY()));
        corners.add(this.ctx.makePoint(rect.getMaxX(), rect.getMinY()));
        return corners;
    }

    @Test
    public void testRectIntersect() {
        new RectIntersectionTestHelper<BufferedLine>(this.ctx){

            @Override
            protected BufferedLine generateRandomShape(Point nearP) {
                Rectangle nearR = this.randomRectangle(nearP);
                ArrayList corners = BufferedLineTest.this.quadrantCorners(nearR);
                int r4 = 2.randomInt((int)3);
                Point pA = (Point)corners.get(r4);
                Point pB = (Point)corners.get((r4 + 2) % 4);
                double maxBuf = Math.max(nearR.getWidth(), nearR.getHeight());
                double buf = Math.abs(2.randomGaussian()) * maxBuf / 4.0;
                buf = 2.randomInt((int)((int)this.divisible(buf)));
                return new BufferedLine(pA, pB, buf, this.ctx);
            }

            @Override
            protected Point randomPointInEmptyShape(BufferedLine shape) {
                int r = 2.randomInt((int)1);
                if (r == 0) {
                    return shape.getA();
                }
                return shape.getB();
            }
        }.testRelateWithRectangle();
    }

    private BufferedLine newBufLine(int x1, int y1, int x2, int y2, int buf) {
        Point pA = this.ctx.makePoint((double)x1, (double)y1);
        Point pB = this.ctx.makePoint((double)x2, (double)y2);
        if (BufferedLineTest.randomBoolean()) {
            return new BufferedLine(pB, pA, (double)buf, this.ctx);
        }
        return new BufferedLine(pA, pB, (double)buf, this.ctx);
    }
}

