/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.RectIntersectionTestHelper;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.impl.BufferedLineString;
import com.spatial4j.core.shape.impl.RectangleImpl;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class BufferedLineStringTest
extends RandomizedTest {
    private final SpatialContext ctx = new SpatialContextFactory(){
        {
            this.geo = false;
            this.worldBounds = new RectangleImpl(-100.0, 100.0, -50.0, 50.0, null);
        }
    }.newSpatialContext();

    @Test
    public void testRectIntersect() {
        new RectIntersectionTestHelper<BufferedLineString>(this.ctx){

            @Override
            protected BufferedLineString generateRandomShape(Point nearP) {
                Rectangle nearR = this.randomRectangle(nearP);
                int numPoints = 2 + 2.randomInt((int)3);
                ArrayList<Point> points = new ArrayList<Point>(numPoints);
                while (points.size() < numPoints) {
                    points.add(this.randomPointIn(nearR));
                }
                double maxBuf = Math.max(nearR.getWidth(), nearR.getHeight());
                double buf = Math.abs(2.randomGaussian()) * maxBuf / 4.0;
                buf = 2.randomInt((int)((int)this.divisible(buf)));
                return new BufferedLineString(points, buf, this.ctx);
            }

            @Override
            protected Point randomPointInEmptyShape(BufferedLineString shape) {
                List points = shape.getPoints();
                return (Point)points.get(2.randomInt((int)(points.size() - 1)));
            }
        }.testRelateWithRectangle();
    }
}

