/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.TestLog;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.RandomizedShapeTest;
import com.spatial4j.core.shape.RectIntersectionTestHelper;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractTestShapes
extends RandomizedShapeTest {
    @Rule
    public final TestLog testLog = TestLog.instance;

    public AbstractTestShapes(SpatialContext ctx) {
        super(ctx);
    }

    protected void testRectangle(double minX, double width, double minY, double height) {
        double maxX = minX + width;
        double maxY = minY + height;
        minX = this.normX(minX);
        maxX = this.normX(maxX);
        Rectangle r = this.ctx.makeRectangle(minX, maxX, minY, maxY);
        Rectangle r2 = this.ctx.makeRectangle(minX, maxX, minY, maxY);
        AbstractTestShapes.assertEquals((Object)r, (Object)r2);
        AbstractTestShapes.assertEquals((long)r.hashCode(), (long)r2.hashCode());
        String msg = r.toString();
        AbstractTestShapes.assertEquals((String)msg, (Object)(width != 0.0 && height != 0.0 ? 1 : 0), (Object)r.hasArea());
        AbstractTestShapes.assertEquals((String)msg, (Object)(width != 0.0 && height != 0.0 ? 1 : 0), (Object)(r.getArea(this.ctx) > 0.0 ? 1 : 0));
        if (this.ctx.isGeo() && r.getWidth() == 360.0 && r.getHeight() == 180.0) {
            double earthRadius = DistanceUtils.toDegrees((double)1.0);
            AbstractTestShapes.assertEquals((double)(Math.PI * 4 * earthRadius * earthRadius), (double)r.getArea(this.ctx), (double)1.0);
        }
        this.assertEqualsRatio(msg, height, r.getHeight());
        this.assertEqualsRatio(msg, width, r.getWidth());
        Point center = r.getCenter();
        msg = msg + " ctr:" + center;
        this.assertRelation(msg, SpatialRelation.CONTAINS, (Shape)r, (Shape)center);
        DistanceCalculator dc = this.ctx.getDistCalc();
        double dUR = dc.distance(center, r.getMaxX(), r.getMaxY());
        double dLR = dc.distance(center, r.getMaxX(), r.getMinY());
        double dUL = dc.distance(center, r.getMinX(), r.getMaxY());
        double dLL = dc.distance(center, r.getMinX(), r.getMinY());
        AbstractTestShapes.assertEquals((String)msg, (Object)(width != 0.0 || height != 0.0 ? 1 : 0), (Object)(dUR != 0.0 ? 1 : 0));
        if (dUR != 0.0) {
            AbstractTestShapes.assertTrue((dUR > 0.0 && dLL > 0.0 ? 1 : 0) != 0);
        }
        this.assertEqualsRatio(msg, dUR, dUL);
        this.assertEqualsRatio(msg, dLR, dLL);
        if (!this.ctx.isGeo() || center.getY() == 0.0) {
            this.assertEqualsRatio(msg, dUR, dLL);
        }
    }

    protected void testRectIntersect() {
        double INCR = 45.0;
        double Y = 20.0;
        for (double left = -180.0; left <= 180.0; left += 45.0) {
            double right = left;
            while (right - left <= 360.0) {
                Rectangle r2;
                double right2;
                double left2;
                Rectangle r = this.makeNormRect(left, right, -20.0, 20.0);
                for (left2 = left; left2 <= right; left2 += 45.0) {
                    for (right2 = left2; right2 <= right; right2 += 45.0) {
                        r2 = this.makeNormRect(left2, right2, -20.0, 20.0);
                        this.assertRelation(null, SpatialRelation.CONTAINS, (Shape)r, (Shape)r2);
                        this.assertRelation(null, SpatialRelation.CONTAINS, (Shape)r, (Shape)r2.getCenter());
                    }
                }
                left2 = right + 45.0;
                while (left2 - left < 360.0) {
                    this.assertRelation(null, SpatialRelation.DISJOINT, (Shape)r, (Shape)this.ctx.makePoint(this.normX(left2), (double)AbstractTestShapes.randomIntBetween((int)-90, (int)90)));
                    right2 = left2;
                    while (right2 - left < 360.0) {
                        r2 = this.makeNormRect(left2, right2, -20.0, 20.0);
                        this.assertRelation(null, SpatialRelation.DISJOINT, (Shape)r, (Shape)r2);
                        right2 += 45.0;
                    }
                    left2 += 45.0;
                }
                for (left2 = left + 45.0; left2 <= right; left2 += 45.0) {
                    right2 = right + 45.0;
                    while (right2 - left < 360.0) {
                        r2 = this.makeNormRect(left2, right2, -20.0, 20.0);
                        this.assertRelation(null, SpatialRelation.INTERSECTS, (Shape)r, (Shape)r2);
                        right2 += 45.0;
                    }
                }
                right += 45.0;
            }
        }
    }

    protected void testCircle(double x, double y, double dist) {
        Circle c = this.ctx.makeCircle(x, y, dist);
        String msg = c.toString();
        Circle c2 = this.ctx.makeCircle(this.ctx.makePoint(x, y), dist);
        AbstractTestShapes.assertEquals((Object)c, (Object)c2);
        AbstractTestShapes.assertEquals((long)c.hashCode(), (long)c2.hashCode());
        AbstractTestShapes.assertEquals((String)msg, (Object)(dist > 0.0 ? 1 : 0), (Object)c.hasArea());
        double area = c.getArea(this.ctx);
        AbstractTestShapes.assertTrue((String)msg, (c.hasArea() == area > 0.0 ? 1 : 0) != 0);
        Rectangle bbox = c.getBoundingBox();
        AbstractTestShapes.assertEquals((String)msg, (Object)(dist > 0.0 ? 1 : 0), (Object)(bbox.getArea(this.ctx) > 0.0 ? 1 : 0));
        AbstractTestShapes.assertTrue((String)msg, (area <= bbox.getArea(this.ctx) ? 1 : 0) != 0);
        if (!this.ctx.isGeo()) {
            this.assertEqualsRatio(msg, bbox.getHeight(), dist * 2.0);
            this.assertEqualsRatio(msg, bbox.getWidth(), dist * 2.0);
        }
        this.assertRelation(msg, SpatialRelation.CONTAINS, (Shape)c, (Shape)c.getCenter());
        this.assertRelation(msg, SpatialRelation.CONTAINS, (Shape)bbox, (Shape)c);
    }

    protected void testCircleIntersect() {
        new RectIntersectionTestHelper<Circle>(this.ctx){

            @Override
            protected Circle generateRandomShape(Point nearP) {
                double cX = this.randomIntBetweenDivisible(-180, 179);
                double cY = this.randomIntBetweenDivisible(-90, 90);
                double cR_dist = this.randomIntBetweenDivisible(0, 180);
                return this.ctx.makeCircle(cX, cY, cR_dist);
            }

            @Override
            protected Point randomPointInEmptyShape(Circle shape) {
                return shape.getCenter();
            }

            @Override
            protected void onAssertFail(AssertionError e, Circle s, Rectangle r, SpatialRelation ic) {
                double radius = s.getRadius();
                if (radius == 180.0) {
                    throw e;
                }
                if (radius == 0.0) {
                    Point p = s.getCenter();
                    if (p.getX() == r.getMinX() || p.getX() == r.getMaxX() || p.getY() == r.getMinY() || p.getY() == r.getMaxY()) {
                        return;
                    }
                    throw e;
                }
                double eps = 1.0E-7;
                s.reset(s.getCenter().getX(), s.getCenter().getY(), radius - 1.0E-7);
                SpatialRelation rel1 = s.relate((Shape)r);
                s.reset(s.getCenter().getX(), s.getCenter().getY(), radius + 1.0E-7);
                SpatialRelation rel2 = s.relate((Shape)r);
                if (rel1 == rel2) {
                    throw e;
                }
                s.reset(s.getCenter().getX(), s.getCenter().getY(), radius);
                System.out.println("Seed " + 1.getContext().getRunnerSeedAsString() + ": Hid assertion due to ambiguous edge touch: " + s + " " + r);
            }
        }.testRelateWithRectangle();
    }

    @Test
    public void testMakeRect() {
        AbstractTestShapes.assertEquals((Object)new RectangleImpl(1.0, 3.0, 2.0, 4.0, this.ctx), (Object)new RectangleImpl((Point)new PointImpl(1.0, 2.0, this.ctx), (Point)new PointImpl(3.0, 4.0, this.ctx), this.ctx));
        AbstractTestShapes.assertEquals((Object)this.ctx.makeRectangle(1.0, 3.0, 2.0, 4.0), (Object)this.ctx.makeRectangle(this.ctx.makePoint(1.0, 2.0), this.ctx.makePoint(3.0, 4.0)));
    }

    protected void testEmptiness(Shape emptyShape) {
        AbstractTestShapes.assertTrue((boolean)emptyShape.isEmpty());
        Point emptyPt = emptyShape.getCenter();
        AbstractTestShapes.assertTrue((boolean)emptyPt.isEmpty());
        Rectangle emptyRect = emptyShape.getBoundingBox();
        AbstractTestShapes.assertTrue((boolean)emptyRect.isEmpty());
        AbstractTestShapes.assertEquals((Object)emptyRect, (Object)emptyShape.getBoundingBox());
        AbstractTestShapes.assertEquals((Object)emptyPt, (Object)emptyShape.getCenter());
        this.assertRelation("EMPTY", SpatialRelation.DISJOINT, emptyShape, (Shape)emptyPt);
        this.assertRelation("EMPTY", SpatialRelation.DISJOINT, emptyShape, (Shape)this.randomPoint());
        this.assertRelation("EMPTY", SpatialRelation.DISJOINT, emptyShape, (Shape)emptyRect);
        this.assertRelation("EMPTY", SpatialRelation.DISJOINT, emptyShape, (Shape)this.randomRectangle(10));
        AbstractTestShapes.assertTrue((boolean)emptyShape.getBuffered((double)AbstractTestShapes.randomInt((int)4), this.ctx).isEmpty());
    }
}

