/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.WKTReader;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Test;

public class WktShapeParserTest
extends RandomizedTest {
    final SpatialContext ctx;

    protected WktShapeParserTest(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public WktShapeParserTest() {
        this(SpatialContext.GEO);
    }

    protected void assertParses(String wkt, Shape expected) throws ParseException {
        WktShapeParserTest.assertEquals((Object)this.ctx.readShapeFromWkt(wkt), (Object)expected);
    }

    protected void assertFails(String wkt) {
        try {
            this.ctx.readShapeFromWkt(wkt);
            WktShapeParserTest.fail((String)"ParseException expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testNoOp() throws ParseException {
        WKTReader wktShapeParser = this.ctx.getWktShapeParser();
        WktShapeParserTest.assertNull((Object)wktShapeParser.parseIfSupported(""));
        WktShapeParserTest.assertNull((Object)wktShapeParser.parseIfSupported("  "));
        WktShapeParserTest.assertNull((Object)wktShapeParser.parseIfSupported("BogusShape()"));
        WktShapeParserTest.assertNull((Object)wktShapeParser.parseIfSupported("BogusShape"));
    }

    @Test
    public void testParsePoint() throws ParseException {
        this.assertParses("POINT (100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses(" POINT (100 90) ", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("point (100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ( 100 90 )", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT(100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT (-45 90 )", (Shape)this.ctx.makePoint(-45.0, 90.0));
        Point expected = this.ctx.makePoint(-45.3, 80.4);
        this.assertParses("POINT (-45.3 80.4 )", (Shape)expected);
        this.assertParses("POINT (-45.3 +80.4 )", (Shape)expected);
        this.assertParses("POINT (-45.3 8.04e1 )", (Shape)expected);
        this.assertParses("POINT EMPTY", (Shape)this.ctx.makePoint(Double.NaN, Double.NaN));
        this.assertParses("POINT (100 90 2)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT (100 90 2 3)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ZM ( 100 90 )", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ZM ( 100 90 -3 -4)", (Shape)this.ctx.makePoint(100.0, 90.0));
    }

    @Test
    public void testParsePoint_invalidDefinitions() {
        this.assertFails("POINT 100 90");
        this.assertFails("POINT (100 90");
        this.assertFails("POINT (100, 90)");
        this.assertFails("POINT 100 90)");
        this.assertFails("POINT (100)");
        this.assertFails("POINT (10f0 90)");
        this.assertFails("POINT (EMPTY)");
        this.assertFails("POINT (1 2), POINT (2 3)");
        this.assertFails("POINT EMPTY (1 2)");
        this.assertFails("POINT ZM EMPTY (1 2)");
        this.assertFails("POINT ZM EMPTY 1");
    }

    @Test
    public void testParseMultiPoint() throws ParseException {
        ShapeCollection s1 = this.ctx.makeCollection(Collections.singletonList(this.ctx.makePoint(10.0, 40.0)));
        this.assertParses("MULTIPOINT (10 40)", (Shape)s1);
        ShapeCollection s4 = this.ctx.makeCollection(Arrays.asList(this.ctx.makePoint(10.0, 40.0), this.ctx.makePoint(40.0, 30.0), this.ctx.makePoint(20.0, 20.0), this.ctx.makePoint(30.0, 10.0)));
        this.assertParses("MULTIPOINT ((10 40), (40 30), (20 20), (30 10))", (Shape)s4);
        this.assertParses("MULTIPOINT (10 40, 40 30, 20 20, 30 10)", (Shape)s4);
        this.assertParses("MULTIPOINT Z EMPTY", (Shape)this.ctx.makeCollection(Collections.EMPTY_LIST));
    }

    @Test
    public void testParseEnvelope() throws ParseException {
        Rectangle r = this.ctx.makeRectangle(this.ctx.makePoint(10.0, 25.0), this.ctx.makePoint(30.0, 45.0));
        this.assertParses(" ENVELOPE ( 10 , 30 , 45 , 25 ) ", (Shape)r);
        this.assertParses("ENVELOPE(10,30,45,25) ", (Shape)r);
        this.assertFails("ENVELOPE (10 30 45 25)");
    }

    @Test
    public void testLineStringShape() throws ParseException {
        Point p1 = this.ctx.makePoint(1.0, 10.0);
        Point p2 = this.ctx.makePoint(2.0, 20.0);
        Point p3 = this.ctx.makePoint(3.0, 30.0);
        Shape ls = this.ctx.makeLineString(Arrays.asList(p1, p2, p3));
        this.assertParses("LINESTRING (1 10, 2 20, 3 30)", ls);
        this.assertParses("LINESTRING EMPTY", this.ctx.makeLineString(Collections.emptyList()));
    }

    @Test
    public void testMultiLineStringShape() throws ParseException {
        ShapeCollection s = this.ctx.makeCollection(Arrays.asList(this.ctx.makeLineString(Arrays.asList(this.ctx.makePoint(10.0, 10.0), this.ctx.makePoint(20.0, 20.0), this.ctx.makePoint(10.0, 40.0))), this.ctx.makeLineString(Arrays.asList(this.ctx.makePoint(40.0, 40.0), this.ctx.makePoint(30.0, 30.0), this.ctx.makePoint(40.0, 20.0), this.ctx.makePoint(30.0, 10.0)))));
        this.assertParses("MULTILINESTRING ((10 10, 20 20, 10 40),\n(40 40, 30 30, 40 20, 30 10))", (Shape)s);
        this.assertParses("MULTILINESTRING M EMPTY", (Shape)this.ctx.makeCollection(Collections.EMPTY_LIST));
    }

    @Test
    public void testGeomCollection() throws ParseException {
        ShapeCollection s1 = this.ctx.makeCollection(Arrays.asList(this.ctx.makePoint(1.0, 2.0)));
        ShapeCollection s2 = this.ctx.makeCollection(Arrays.asList(this.ctx.makeRectangle(1.0, 2.0, 3.0, 4.0), this.ctx.makePoint(-1.0, -2.0)));
        this.assertParses("GEOMETRYCOLLECTION (POINT (1 2) )", (Shape)s1);
        this.assertParses("GEOMETRYCOLLECTION ( ENVELOPE(1,2,4,3), POINT(-1 -2)) ", (Shape)s2);
        this.assertParses("GEOMETRYCOLLECTION EMPTY", (Shape)this.ctx.makeCollection(Collections.EMPTY_LIST));
        this.assertParses("GEOMETRYCOLLECTION ( POINT EMPTY )", (Shape)this.ctx.makeCollection(Arrays.asList(this.ctx.makePoint(Double.NaN, Double.NaN))));
    }

    @Test
    public void testBuffer() throws ParseException {
        this.assertParses("BUFFER(POINT(1 2), 3)", this.ctx.makePoint(1.0, 2.0).getBuffered(3.0, this.ctx));
    }
}

