/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.io.WKTReader;
import com.spatial4j.core.io.WktShapeParserTest;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.PointImpl;
import java.text.ParseException;
import org.junit.Test;

public class WktCustomShapeParserTest
extends WktShapeParserTest {
    public WktCustomShapeParserTest() {
        super(WktCustomShapeParserTest.makeCtx());
    }

    private static SpatialContext makeCtx() {
        SpatialContextFactory factory = new SpatialContextFactory();
        factory.readers.clear();
        factory.readers.add(MyWKTShapeParser.class);
        return factory.newSpatialContext();
    }

    @Test
    public void testCustomShape() throws ParseException {
        WktCustomShapeParserTest.assertEquals((Object)"customShape", (Object)((CustomShape)this.ctx.readShapeFromWkt("customShape()")).name);
        WktCustomShapeParserTest.assertEquals((Object)"custom3d", (Object)((CustomShape)this.ctx.readShapeFromWkt("custom3d ()")).name);
    }

    @Test
    public void testNextSubShapeString() throws ParseException {
        WKTReader.State state = this.ctx.getWktShapeParser().newState("OUTER(INNER(3, 5))");
        state.offset = 0;
        WktCustomShapeParserTest.assertEquals((Object)"OUTER(INNER(3, 5))", (Object)state.nextSubShapeString());
        WktCustomShapeParserTest.assertEquals((long)"OUTER(INNER(3, 5))".length(), (long)state.offset);
        state.offset = "OUTER(".length();
        WktCustomShapeParserTest.assertEquals((Object)"INNER(3, 5)", (Object)state.nextSubShapeString());
        WktCustomShapeParserTest.assertEquals((long)"OUTER(INNER(3, 5)".length(), (long)state.offset);
        state.offset = "OUTER(INNER(".length();
        WktCustomShapeParserTest.assertEquals((Object)"3", (Object)state.nextSubShapeString());
        WktCustomShapeParserTest.assertEquals((long)"OUTER(INNER(3".length(), (long)state.offset);
    }

    public static class MyWKTShapeParser
    extends WKTReader {
        public MyWKTShapeParser(SpatialContext ctx, SpatialContextFactory factory) {
            super(ctx, factory);
        }

        protected WKTReader.State newState(String wkt) {
            Object other = null;
            return new WKTReader.State((WKTReader)this, wkt);
        }

        public Shape parseShapeByType(WKTReader.State state, String shapeType) throws ParseException {
            Shape result = super.parseShapeByType(state, shapeType);
            if (result == null && shapeType.contains("custom")) {
                state.nextExpect('(');
                state.nextExpect(')');
                return new CustomShape(shapeType, this.ctx);
            }
            return result;
        }
    }

    static class CustomShape
    extends PointImpl {
        private final String name;

        public CustomShape(String name, SpatialContext ctx) {
            super(0.0, 0.0, ctx);
            this.name = name;
        }
    }
}

