/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Test;

public class ShapeReadWriterTest
extends RandomizedTest {
    private final SpatialContext ctx;

    @ParametersFactory
    public static Iterable<Object[]> parameters() {
        return Arrays.asList(ShapeReadWriterTest.$$((Object[][])new Object[][]{ShapeReadWriterTest.$((Object[])new Object[]{SpatialContext.GEO}), ShapeReadWriterTest.$((Object[])new Object[]{JtsSpatialContext.GEO})}));
    }

    public ShapeReadWriterTest(SpatialContext ctx) {
        this.ctx = ctx;
    }

    private <T extends Shape> T writeThenRead(T s) throws IOException {
        String buff = this.ctx.toString(s);
        return (T)this.ctx.readShape(buff);
    }

    @Test
    public void testPoint() throws IOException {
        Shape s = this.ctx.readShape("10 20");
        ShapeReadWriterTest.assertEquals((Object)this.ctx.makePoint(10.0, 20.0), (Object)s);
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.writeThenRead(s));
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.ctx.readShape("20,10"));
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.ctx.readShape("20, 10"));
        ShapeReadWriterTest.assertFalse((boolean)s.hasArea());
    }

    @Test
    public void testRectangle() throws IOException {
        Shape s = this.ctx.readShape("-10 -20 10 20");
        ShapeReadWriterTest.assertEquals((Object)this.ctx.makeRectangle(-10.0, 10.0, -20.0, 20.0), (Object)s);
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.writeThenRead(s));
        ShapeReadWriterTest.assertTrue((boolean)s.hasArea());
    }

    @Test
    public void testCircle() throws IOException {
        Shape s = this.ctx.readShape("Circle(1.23 4.56 distance=7.89)");
        ShapeReadWriterTest.assertEquals((Object)this.ctx.makeCircle(1.23, 4.56, 7.89), (Object)s);
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.writeThenRead(s));
        ShapeReadWriterTest.assertEquals((Object)s, (Object)this.ctx.readShape("CIRCLE( 4.56,1.23 d=7.89 )"));
        ShapeReadWriterTest.assertTrue((boolean)s.hasArea());
    }
}

