/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;

public class PolygonBuilder {
    private final JtsSpatialContext ctx;
    private final List<Coordinate> points = new ArrayList<Coordinate>();
    private final List<LinearRing> holes = new ArrayList<LinearRing>();

    public PolygonBuilder(JtsSpatialContext ctx) {
        this.ctx = ctx;
    }

    public PolygonBuilder point(double lon, double lat) {
        this.points.add(new Coordinate(lon, lat));
        return this;
    }

    public PolygonHoleBuilder newHole() {
        return new PolygonHoleBuilder(this);
    }

    private PolygonBuilder addHole(LinearRing linearRing) {
        this.holes.add(linearRing);
        return this;
    }

    public Shape build() {
        return new JtsGeometry((Geometry)this.toPolygon(), this.ctx, true, true);
    }

    public Polygon toPolygon() {
        LinearRing ring = this.ctx.getGeometryFactory().createLinearRing(this.points.toArray(new Coordinate[this.points.size()]));
        LinearRing[] holes = this.holes.isEmpty() ? null : this.holes.toArray(new LinearRing[this.holes.size()]);
        return this.ctx.getGeometryFactory().createPolygon(ring, holes);
    }

    public class PolygonHoleBuilder {
        private final List<Coordinate> points = new ArrayList<Coordinate>();
        private final PolygonBuilder polygonBuilder;

        private PolygonHoleBuilder(PolygonBuilder polygonBuilder2) {
            this.polygonBuilder = polygonBuilder2;
        }

        public PolygonHoleBuilder point(double lon, double lat) {
            this.points.add(new Coordinate(lon, lat));
            return this;
        }

        public PolygonBuilder endHole() {
            return this.polygonBuilder.addHole(PolygonBuilder.this.ctx.getGeometryFactory().createLinearRing(this.points.toArray(new Coordinate[this.points.size()])));
        }
    }
}

