/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.context.jts.ValidationRule;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.PolygonBuilder;
import com.spatial4j.core.io.WktShapeParserTest;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.SpatialRelation;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Test;

public class JtsWktShapeParserTest
extends WktShapeParserTest {
    final JtsSpatialContext ctx;

    public JtsWktShapeParserTest() {
        super((SpatialContext)JtsSpatialContext.GEO);
        this.ctx = (JtsSpatialContext)((WktShapeParserTest)this).ctx;
    }

    @Test
    public void testParsePolygon() throws ParseException {
        Shape polygonNoHoles = new PolygonBuilder(this.ctx).point(100.0, 0.0).point(101.0, 0.0).point(101.0, 1.0).point(100.0, 2.0).point(100.0, 0.0).build();
        String polygonNoHolesSTR = "POLYGON ((100 0, 101 0, 101 1, 100 2, 100 0))";
        this.assertParses(polygonNoHolesSTR, polygonNoHoles);
        this.assertParses("POLYGON((100 0,101 0,101 1,100 2,100 0))", polygonNoHoles);
        this.assertParses("GEOMETRYCOLLECTION ( " + polygonNoHolesSTR + ")", (Shape)this.ctx.makeCollection(Arrays.asList(polygonNoHoles)));
        Shape polygonWithHoles = new PolygonBuilder(this.ctx).point(100.0, 0.0).point(101.0, 0.0).point(101.0, 1.0).point(100.0, 1.0).point(100.0, 0.0).newHole().point(100.2, 0.2).point(100.8, 0.2).point(100.8, 0.8).point(100.2, 0.8).point(100.2, 0.2).endHole().build();
        this.assertParses("POLYGON ((100 0, 101 0, 101 1, 100 1, 100 0), (100.2 0.2, 100.8 0.2, 100.8 0.8, 100.2 0.8, 100.2 0.2))", polygonWithHoles);
        GeometryFactory gf = this.ctx.getGeometryFactory();
        this.assertParses("POLYGON EMPTY", (Shape)this.ctx.makeShape((Geometry)gf.createPolygon(gf.createLinearRing(new Coordinate[0]), null)));
    }

    @Test
    public void testPolyToRect() throws ParseException {
        this.assertParses("POLYGON((0 5, 10 5, 10 20, 0 20, 0 5))", (Shape)this.ctx.makeRectangle(0.0, 10.0, 5.0, 20.0));
    }

    @Test
    public void polyToRect180Rule() throws ParseException {
        Rectangle expected = this.ctx.makeRectangle(160.0, -170.0, 0.0, 10.0);
        this.assertParses("POLYGON((160 0, -170 0, -170 10, 160 10, 160 0))", (Shape)expected);
        this.assertParses("POLYGON((160 10, -170 10, -170 0, 160 0, 160 10))", (Shape)expected);
    }

    @Test
    public void polyToRectCcwRule() throws ParseException {
        JtsSpatialContext ctx = new JtsSpatialContextFactory(){
            {
                this.datelineRule = DatelineRule.ccwRect;
            }
        }.newSpatialContext();
        JtsWktShapeParserTest.assertEquals((Object)ctx.readShapeFromWkt("POLYGON((160 0, -170 0, -170 10, 160 10, 160 0))"), (Object)ctx.makeRectangle(160.0, -170.0, 0.0, 10.0));
        JtsWktShapeParserTest.assertEquals((Object)ctx.readShapeFromWkt("POLYGON((160 10, -170 10, -170 0, 160 0, 160 10))"), (Object)ctx.makeRectangle(-170.0, 160.0, 0.0, 10.0));
    }

    @Test
    public void testParseMultiPolygon() throws ParseException {
        Shape p1 = new PolygonBuilder(this.ctx).point(100.0, 0.0).point(101.0, 0.0).point(101.0, 2.0).point(100.0, 1.0).point(100.0, 0.0).build();
        Shape p2 = new PolygonBuilder(this.ctx).point(100.0, 0.0).point(102.0, 0.0).point(102.0, 2.0).point(100.0, 1.0).point(100.0, 0.0).build();
        ShapeCollection s = this.ctx.makeCollection(Arrays.asList(p1, p2));
        this.assertParses("MULTIPOLYGON(((100 0, 101 0, 101 2, 100 1, 100 0)),((100 0, 102 0, 102 2, 100 1, 100 0)))", (Shape)s);
        this.assertParses("MULTIPOLYGON EMPTY", (Shape)this.ctx.makeCollection(Collections.EMPTY_LIST));
    }

    @Test
    public void testLineStringDateline() throws ParseException {
        Shape s = this.ctx.readShapeFromWkt("LINESTRING(160 10, -170 15)");
        JtsWktShapeParserTest.assertEquals((double)30.0, (double)s.getBoundingBox().getWidth(), (double)0.0);
    }

    @Test
    public void testWrapTopologyException() throws Exception {
        assert (this.ctx.getValidationRule() != ValidationRule.none);
        try {
            this.ctx.readShapeFromWkt("POLYGON((0 0, 10 0, 10 20))");
            JtsWktShapeParserTest.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.readShapeFromWkt("POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))");
            JtsWktShapeParserTest.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
    }

    @Test
    public void testPolygonRepair() throws ParseException {
        System.setProperty("spatial4j.JtsGeometry.assertValidate", "false");
        String wkt = "POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))";
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.repairBuffer0;
        JtsSpatialContext ctx = factory.newSpatialContext();
        Shape buffer0 = ctx.readShapeFromWkt(wkt);
        JtsWktShapeParserTest.assertTrue((buffer0.getArea((SpatialContext)ctx) > 0.0 ? 1 : 0) != 0);
        factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.repairConvexHull;
        ctx = factory.newSpatialContext();
        Shape cvxHull = ctx.readShapeFromWkt(wkt);
        JtsWktShapeParserTest.assertTrue((cvxHull.getArea((SpatialContext)ctx) > 0.0 ? 1 : 0) != 0);
        JtsWktShapeParserTest.assertEquals((Object)SpatialRelation.CONTAINS, (Object)cvxHull.relate(buffer0));
        factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.none;
        ctx = factory.newSpatialContext();
        ctx.readShapeFromWkt(wkt);
    }
}

