/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.jts.JtsWKTReaderShapeParser;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.junit.Test;

public class JtsWKTReaderShapeParserTest
extends RandomizedTest {
    final SpatialContext ctx;

    public JtsWKTReaderShapeParserTest() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.datelineRule = DatelineRule.ccwRect;
        factory.readers.clear();
        factory.readers.add(JtsWKTReaderShapeParser.class);
        this.ctx = factory.newSpatialContext();
    }

    @Test
    public void wktGeoPt() throws IOException {
        Shape s = this.ctx.readShape("Point(-160 30)");
        JtsWKTReaderShapeParserTest.assertEquals((Object)this.ctx.makePoint(-160.0, 30.0), (Object)s);
    }

    @Test
    public void wktGeoRect() throws IOException {
        Shape sNoDL = this.ctx.readShape("Polygon((-170 30, -170 15,  160 15,  160 30, -170 30))");
        Rectangle expectedNoDL = this.ctx.makeRectangle(-170.0, 160.0, 15.0, 30.0);
        JtsWKTReaderShapeParserTest.assertTrue((!expectedNoDL.getCrossesDateLine() ? 1 : 0) != 0);
        JtsWKTReaderShapeParserTest.assertEquals((Object)expectedNoDL, (Object)sNoDL);
        Shape sYesDL = this.ctx.readShape("Polygon(( 160 30,  160 15, -170 15, -170 30,  160 30))");
        Rectangle expectedYesDL = this.ctx.makeRectangle(160.0, -170.0, 15.0, 30.0);
        JtsWKTReaderShapeParserTest.assertTrue((boolean)expectedYesDL.getCrossesDateLine());
        JtsWKTReaderShapeParserTest.assertEquals((Object)expectedYesDL, (Object)sYesDL);
    }

    @Test
    public void testWrapTopologyException() {
        try {
            this.ctx.readShape("POLYGON((0 0, 10 0, 10 20))");
            JtsWKTReaderShapeParserTest.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.readShape("POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))");
            JtsWKTReaderShapeParserTest.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
    }
}

