/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.io.BaseRoundTripTest;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.io.ShapeWriter;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Geometry;
import io.jeo.geom.GeomBuilder;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class GeneralReadWriteShapeTest
extends BaseRoundTripTest<JtsSpatialContext> {
    protected GeomBuilder gb;

    @Before
    public void setUp() {
        this.gb = new GeomBuilder();
    }

    @Override
    public JtsSpatialContext initContext() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = true;
        factory.normWrapLongitude = true;
        factory.useJtsLineString = false;
        return new JtsSpatialContext(factory);
    }

    protected abstract ShapeReader getShapeReader();

    protected abstract ShapeWriter getShapeWriter();

    protected abstract ShapeWriter getShapeWriterForTests();

    @Override
    protected void assertRoundTrip(Shape shape, boolean andEquals) throws Exception {
        String str = this.getShapeWriter().toString(shape);
        Shape out = this.getShapeReader().read((Object)str);
        ShapeWriter writer = this.getShapeWriterForTests();
        Assert.assertEquals((Object)writer.toString(shape), (Object)writer.toString(out));
        if (andEquals) {
            Assert.assertEquals((Object)shape, (Object)out);
        }
    }

    @Test
    public void testWriteThenReadPoint() throws Exception {
        this.assertRoundTrip((Shape)this.point());
    }

    @Test
    public void testWriteThenReadLineString() throws Exception {
        this.assertRoundTrip(this.line());
    }

    @Test
    public void testWriteThenReadPolygon() throws Exception {
        this.assertRoundTrip(this.polygon1());
        this.assertRoundTrip(this.polygon2());
    }

    @Test
    public void testWriteThenReadMultiPoint() throws Exception {
        this.assertRoundTrip(this.multiPoint());
    }

    @Test
    public void testWriteThenReadMultiLineString() throws Exception {
        this.assertRoundTrip(this.multiLine());
    }

    @Test
    public void testWriteThenReadMultiPolygon() throws Exception {
        this.assertRoundTrip(this.multiPolygon());
    }

    @Test
    public void testWriteThenReadRectangle() throws Exception {
        this.assertRoundTrip((Shape)this.polygon1().getBoundingBox());
    }

    @Test
    public void testWriteThenReadCollection() throws Exception {
        this.assertRoundTrip(this.collection());
    }

    @Test
    public void testWriteThenReadBufferedLine() throws Exception {
        this.assertRoundTrip(this.bufferedLine());
    }

    @Test
    public void testWriteThenReadCircle() throws Exception {
        this.assertRoundTrip(this.circle());
    }

    String pointText() {
        return this.strip("{'type': 'Point','coordinates':[100.1,0.1]}");
    }

    Point point() {
        return ((JtsSpatialContext)this.ctx).makePoint(100.1, 0.1);
    }

    String lineText() {
        return this.strip("{'type': 'LineString', 'coordinates': [[100.1,0.1],[101.1,1.1]]}");
    }

    Shape line() {
        return ((JtsSpatialContext)this.ctx).makeLineString(Arrays.asList(((JtsSpatialContext)this.ctx).makePoint(100.1, 0.1), ((JtsSpatialContext)this.ctx).makePoint(101.1, 1.1)));
    }

    Shape polygon1() {
        return ((JtsSpatialContext)this.ctx).makeShape((Geometry)this.gb.points(new double[]{100.1, 0.1, 101.2, 0.1, 101.1, 1.1, 100.1, 1.1, 100.1, 0.1}).ring().toPolygon());
    }

    String polygonText1() {
        return this.strip("{ 'type': 'Polygon','coordinates': [  [ [100.1, 0.1], [101.2, 0.1], [101.1, 1.1], [100.1, 1.1], [100.1, 0.1] ]  ]}");
    }

    String polygonText2() {
        return this.strip("{ 'type': 'Polygon',  'coordinates': [    [ [100.1, 0.1], [101.1, 0.1], [101.1, 1.1], [100.1, 1.1], [100.1, 0.1] ],    [ [100.2, 0.2], [100.8, 0.2], [100.8, 0.8], [100.2, 0.8], [100.2, 0.2] ]    ]   }");
    }

    Shape polygon2() {
        return ((JtsSpatialContext)this.ctx).makeShape((Geometry)this.gb.points(new double[]{100.1, 0.1, 101.1, 0.1, 101.1, 1.1, 100.1, 1.1, 100.1, 0.1}).ring().points(new double[]{100.2, 0.2, 100.8, 0.2, 100.8, 0.8, 100.2, 0.8, 100.2, 0.2}).ring().toPolygon());
    }

    String multiPointText() {
        return this.strip("{ 'type': 'MultiPoint','coordinates': [ [100.1, 0.1], [101.1, 1.1] ]}");
    }

    Shape multiPoint() {
        return ((JtsSpatialContext)this.ctx).makeShape((Geometry)this.gb.points(new double[]{100.1, 0.1, 101.1, 1.1}).toMultiPoint());
    }

    String multiLineText() {
        return this.strip("{ 'type': 'MultiLineString',  'coordinates': [    [ [100.1, 0.1], [101.1, 1.1] ],    [ [102.1, 2.1], [103.1, 3.1] ]    ]  }");
    }

    Shape multiLine() {
        return ((JtsSpatialContext)this.ctx).makeShape((Geometry)this.gb.points(new double[]{100.1, 0.1, 101.1, 1.1}).lineString().points(new double[]{102.1, 2.1, 103.1, 3.1}).lineString().toMultiLineString());
    }

    String multiPolygonText() {
        return this.strip("{ 'type': 'MultiPolygon',  'coordinates': [    [[[102.1, 2.1], [103.1, 2.1], [103.1, 3.1], [102.1, 3.1], [102.1, 2.1]]],    [[[100.1, 0.1], [101.1, 0.1], [101.1, 1.1], [100.1, 1.1], [100.1, 0.1]],     [[100.2, 0.2], [100.8, 0.2], [100.8, 0.8], [100.2, 0.8], [100.2, 0.2]]]    ]  }");
    }

    Shape multiPolygon() {
        return ((JtsSpatialContext)this.ctx).makeShape((Geometry)this.gb.points(new double[]{102.1, 2.1, 103.1, 2.1, 103.1, 3.1, 102.1, 3.1, 102.1, 2.1}).ring().polygon().points(new double[]{100.1, 0.1, 101.1, 0.1, 101.1, 1.1, 100.1, 1.1, 100.1, 0.1}).ring().points(new double[]{100.2, 0.2, 100.8, 0.2, 100.8, 0.8, 100.2, 0.8, 100.2, 0.2}).ring().polygon().toMultiPolygon());
    }

    Rectangle rectangle() {
        return ((JtsSpatialContext)this.ctx).makeRectangle(100.1, 101.1, 0.1, 1.1);
    }

    String rectangleText() {
        return this.strip("{'type':'Polygon','coordinates': [[[100.1,0.1], [100.1,1.1], [101.1,1.1], [101.1,0.1], [100.1,0.1]]]}");
    }

    String collectionText() {
        return this.strip("{ 'type': 'GeometryCollection',  'geometries': [    { 'type': 'Point',    'coordinates': [100.1, 0.1]    },    { 'type': 'LineString',    'coordinates': [ [101.1, 0.1], [102.1, 1.1] ]    }  ]  }");
    }

    Shape collection() {
        return ((JtsSpatialContext)this.ctx).makeShapeFromGeometry((Geometry)this.gb.point(100.1, 0.1).point().points(new double[]{101.1, 0.1, 102.1, 1.1}).lineString().toCollection());
    }

    String bufferedLineText() {
        return this.strip("{'type': 'LineString', 'coordinates': [[100.1,0.1],[101.1,1.1]], 'buffer': 1111.950797, 'properties': {'buffer_units': 'km'}}");
    }

    Shape bufferedLine() {
        return ((JtsSpatialContext)this.ctx).makeBufferedLineString(Arrays.asList(((JtsSpatialContext)this.ctx).makePoint(100.1, 0.1), ((JtsSpatialContext)this.ctx).makePoint(101.1, 1.1)), 10.0);
    }

    Shape circle() {
        return ((JtsSpatialContext)this.ctx).makeCircle(1.0, 2.0, 10.0);
    }

    String strip(String json) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == ' ' || c == '\n') continue;
            if (c == '\'') {
                sb.append("\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

