/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.io.GeneralReadWriteShapeTest;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.io.ShapeWriter;
import com.spatial4j.core.shape.Shape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeneralGeoJSONTest
extends GeneralReadWriteShapeTest {
    ShapeReader reader;
    ShapeWriter writer;
    ShapeWriter writerForTests;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.reader = ((JtsSpatialContext)this.ctx).getFormats().getReader("GeoJSON");
        this.writerForTests = this.writer = ((JtsSpatialContext)this.ctx).getFormats().getWriter("GeoJSON");
        Assert.assertNotNull((Object)this.reader);
        Assert.assertNotNull((Object)this.writer);
        Assert.assertNotNull((Object)this.writerForTests);
    }

    @Override
    protected ShapeReader getShapeReader() {
        return this.reader;
    }

    @Override
    protected ShapeWriter getShapeWriter() {
        return this.writer;
    }

    @Override
    protected ShapeWriter getShapeWriterForTests() {
        return this.writerForTests;
    }

    @Override
    @Test
    public void testWriteThenReadCircle() throws Exception {
        this.assertRoundTrip(this.circle(), false);
    }

    @Override
    @Test
    public void testWriteThenReadBufferedLine() throws Exception {
        this.assertRoundTrip(this.bufferedLine(), false);
    }

    @Test
    public void testParsePoint() throws Exception {
        Shape v = this.reader.read((Object)this.pointText());
        GeneralGeoJSONTest.assertTrue((boolean)this.point().equals(v));
    }

    @Test
    public void testEncodePoint() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.pointText(), (Object)this.writer.toString((Shape)this.point()));
    }

    @Test
    public void testParseLineString() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.line(), (Object)this.reader.read((Object)this.lineText()));
    }

    @Test
    public void testEncodeLineString() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.lineText(), (Object)this.strip(this.writer.toString(this.line())));
    }

    @Test
    public void testParsePolygon() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.polygon1(), (Object)this.reader.read((Object)this.polygonText1()));
        GeneralGeoJSONTest.assertEquals((Object)this.polygon2(), (Object)this.reader.read((Object)this.polygonText2()));
    }

    @Test
    public void testEncodePolygon() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.polygonText1(), (Object)this.writer.toString(this.polygon1()));
        GeneralGeoJSONTest.assertEquals((Object)this.polygonText2(), (Object)this.writer.toString(this.polygon2()));
    }

    @Test
    public void testParseMultiPoint() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiPoint(), (Object)this.reader.read((Object)this.multiPointText()));
    }

    @Test
    public void testEncodeMultiPoint() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiPointText(), (Object)this.writer.toString(this.multiPoint()));
    }

    @Test
    public void testParseMultiLineString() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiLine(), (Object)this.reader.read((Object)this.multiLineText()));
    }

    @Test
    public void testEncodeMultiLineString() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiLineText(), (Object)this.writer.toString(this.multiLine()));
    }

    @Test
    public void testParseMultiPolygon() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiPolygon(), (Object)this.reader.read((Object)this.multiPolygonText()));
    }

    @Test
    public void testEncodeMultiPolygon() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.multiPolygonText(), (Object)this.writer.toString(this.multiPolygon()));
    }

    @Test
    public void testEncodeRectangle() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.rectangleText(), (Object)this.strip(this.writer.toString((Shape)this.rectangle())));
    }

    @Test
    public void testParseGeometryCollection() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.collection(), (Object)this.reader.read((Object)this.collectionText()));
    }

    @Test
    public void testEncodeGeometryCollection() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.collectionText(), (Object)this.strip(this.writer.toString(this.collection())));
    }

    @Test
    public void testEncodeBufferedLineString() throws Exception {
        GeneralGeoJSONTest.assertEquals((Object)this.bufferedLineText(), (Object)this.strip(this.writer.toString(this.bufferedLine())));
    }
}

