/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.BaseRoundTripTest;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Test;

public class BinaryCodecTest
extends BaseRoundTripTest<SpatialContext> {
    @Override
    public SpatialContext initContext() {
        return SpatialContext.GEO;
    }

    @Test
    public void testRect() throws Exception {
        this.assertRoundTrip(this.wkt("ENVELOPE(-10, 180, 42.3, 0)"));
    }

    @Test
    public void testCircle() throws Exception {
        this.assertRoundTrip(this.wkt("BUFFER(POINT(-10 30), 5.2)"));
    }

    @Test
    public void testCollection() throws Exception {
        ShapeCollection s = this.ctx.makeCollection(Arrays.asList(this.randomShape(), this.randomShape(), this.randomShape()));
        this.assertRoundTrip((Shape)s);
    }

    @Override
    protected void assertRoundTrip(Shape shape, boolean andEquals) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.binaryCodec.writeShape((DataOutput)new DataOutputStream(baos), shape);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryCodecTest.assertEquals((Object)shape, (Object)this.binaryCodec.readShape((DataInput)new DataInputStream(bais)));
    }
}

