/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.PointImpl;
import org.junit.Before;
import org.junit.Test;

public class TestDistances
extends RandomizedTest {
    private SpatialContext ctx;
    private double EPS;

    @Before
    public void beforeTest() {
        this.ctx = SpatialContext.GEO;
        this.EPS = 0.001;
    }

    private DistanceCalculator dc() {
        return this.ctx.getDistCalc();
    }

    @Test
    public void testSomeDistances() {
        Point ctr = this.pLL(0.0, 100.0);
        TestDistances.assertEquals((double)11100.0, (double)(this.dc().distance(ctr, this.pLL(10.0, 0.0)) * 111.19507973436875), (double)3.0);
        double deg = this.dc().distance(ctr, this.pLL(10.0, -160.0));
        TestDistances.assertEquals((double)11100.0, (double)(deg * 111.19507973436875), (double)3.0);
        TestDistances.assertEquals((double)314.40338, (double)(this.dc().distance(this.pLL(1.0, 2.0), this.pLL(3.0, 4.0)) * 111.19507973436875), (double)this.EPS);
    }

    @Test
    public void testDistancesAgainstVincenty() {
        GeodesicSphereDistCalc.Vincenty vincenty = new GeodesicSphereDistCalc.Vincenty();
        GeodesicSphereDistCalc.Haversine haversine = new GeodesicSphereDistCalc.Haversine();
        GeodesicSphereDistCalc.LawOfCosines lawOfCos = new GeodesicSphereDistCalc.LawOfCosines();
        int TRIES = 100000 * (int)TestDistances.multiplier();
        for (int i = 0; i < TRIES; ++i) {
            Point p1 = this.randomGeoPoint();
            Point p2 = this.randomGeoPointFrom(p1);
            double distV = vincenty.distance(p1, p2);
            double havV = haversine.distance(p1, p2);
            TestDistances.assertEquals((double)distV, (double)havV, (double)(distV <= 90.0 ? 8.993203677616636E-8 : 8.993203677616634E-6));
            if (distV != 0.0 && distV > 1.0E-7) {
                TestDistances.assertEquals((double)1.0, (double)(havV / distV), (double)0.001);
            }
            double locV = lawOfCos.distance(p1, p2);
            TestDistances.assertEquals((double)distV, (double)locV, (double)8.993203677616634E-6);
        }
    }

    private Point randomGeoPoint() {
        return this.ctx.makePoint(TestDistances.randomDouble() * 360.0 + -180.0, TestDistances.randomDouble() * 180.0 + -90.0);
    }

    private Point randomGeoPointFrom(Point p1) {
        int which = TestDistances.randomInt((int)10);
        double distDEG = which <= 2 ? 180.0 - TestDistances.randomDouble() * 0.001 / Math.pow(10.0, which) : (which >= 8 ? TestDistances.randomDouble() * 0.001 / Math.pow(10.0, 10 - which) : TestDistances.randomDouble() * 180.0);
        double bearingDEG = TestDistances.randomDouble() * 360.0;
        Point p2RAD = DistanceUtils.pointOnBearingRAD((double)DistanceUtils.toRadians((double)p1.getY()), (double)DistanceUtils.toRadians((double)p1.getX()), (double)DistanceUtils.toRadians((double)distDEG), (double)DistanceUtils.toRadians((double)bearingDEG), (SpatialContext)this.ctx, null);
        p2RAD.reset(DistanceUtils.toDegrees((double)p2RAD.getX()), DistanceUtils.toDegrees((double)p2RAD.getY()));
        return p2RAD;
    }

    @Test
    public void testHaversineNaN() {
        TestDistances.assertEquals((double)180.0, (double)new GeodesicSphereDistCalc.Haversine().distance(this.ctx.makePoint(-81.05206968336057, 71.82629271026536), 98.9479297952497, -71.82629264390964), (double)1.0E-5);
    }

    @Test
    public void testCalcBoxByDistFromPt() {
        double d = 62.000045473856844;
        Point pCtr = this.pLL(-20.0, 84.0);
        Point pTgt = this.pLL(-42.0, 15.0);
        TestDistances.assertTrue((this.dc().distance(pCtr, pTgt) < d ? 1 : 0) != 0);
        Rectangle r = this.dc().calcBoxByDistFromPt(pCtr, d, this.ctx, null);
        TestDistances.assertEquals((Object)SpatialRelation.CONTAINS, (Object)r.relate((Shape)pTgt));
        this.checkBBox(pCtr, d);
        TestDistances.assertEquals((String)"0 dist, horiz line", (double)-45.0, (double)this.dc().calcBoxByDistFromPt_yHorizAxisDEG(this.ctx.makePoint(-180.0, -45.0), 0.0, this.ctx), (double)0.0);
        double MAXDIST = 20015.114352186374;
        this.checkBBox(this.ctx.makePoint(0.0, 0.0), MAXDIST);
        this.checkBBox(this.ctx.makePoint(0.0, 0.0), MAXDIST * 0.999999);
        this.checkBBox(this.ctx.makePoint(0.0, 0.0), 0.0);
        this.checkBBox(this.ctx.makePoint(0.0, 0.0), 1.0E-6);
        this.checkBBox(this.ctx.makePoint(0.0, 90.0), 1.0E-6);
        this.checkBBox(this.ctx.makePoint(-32.7, -5.42), 9829.0);
        this.checkBBox(this.ctx.makePoint(0.0, 70.0), 2223.901594687375);
        double d2 = 0.01;
        this.checkBBox(this.ctx.makePoint(0.0, 90.0 - (d2 + 0.001) * 0.008993203677616635), d2);
        for (int T = 0; T < 100; ++T) {
            double lat = -90.0 + TestDistances.randomDouble() * 180.0;
            double lon = -180.0 + TestDistances.randomDouble() * 360.0;
            Point ctr = this.ctx.makePoint(lon, lat);
            double dist = MAXDIST * TestDistances.randomDouble();
            this.checkBBox(ctr, dist);
        }
    }

    private void checkBBox(Point ctr, double distKm) {
        String msg = "ctr: " + ctr + " distKm: " + distKm;
        double dist = distKm * 0.008993203677616635;
        Rectangle r = this.dc().calcBoxByDistFromPt(ctr, dist, this.ctx, null);
        double horizAxisLat = this.dc().calcBoxByDistFromPt_yHorizAxisDEG(ctr, dist, this.ctx);
        if (!Double.isNaN(horizAxisLat)) {
            TestDistances.assertTrue((boolean)r.relateYRange(horizAxisLat, horizAxisLat).intersects());
        }
        if (r.getWidth() >= 180.0) {
            double deg = this.dc().distance(ctr, r.getMinX(), r.getMaxY() == 90.0 ? 90.0 : -90.0);
            double calcDistKm = deg * 111.19507973436875;
            TestDistances.assertTrue((String)msg, (calcDistKm <= distKm + this.EPS ? 1 : 0) != 0);
        } else {
            Point tPt = this.findClosestPointOnVertToPoint(r.getMinX(), r.getMinY(), r.getMaxY(), ctr);
            double calcDistKm = this.dc().distance(ctr, tPt) * 111.19507973436875;
            TestDistances.assertEquals((String)msg, (double)distKm, (double)calcDistKm, (double)this.EPS);
            TestDistances.assertEquals((String)msg, (double)tPt.getY(), (double)horizAxisLat, (double)this.EPS);
        }
        double topDistKm = this.dc().distance(ctr, ctr.getX(), r.getMaxY()) * 111.19507973436875;
        if (r.getMaxY() == 90.0) {
            TestDistances.assertTrue((String)msg, (topDistKm <= distKm + this.EPS ? 1 : 0) != 0);
        } else {
            TestDistances.assertEquals((String)msg, (double)distKm, (double)topDistKm, (double)this.EPS);
        }
        double botDistKm = this.dc().distance(ctr, ctr.getX(), r.getMinY()) * 111.19507973436875;
        if (r.getMinY() == -90.0) {
            TestDistances.assertTrue((String)msg, (botDistKm <= distKm + this.EPS ? 1 : 0) != 0);
        } else {
            TestDistances.assertEquals((String)msg, (double)distKm, (double)botDistKm, (double)this.EPS);
        }
    }

    private Point findClosestPointOnVertToPoint(double lon, double lowLat, double highLat, Point ctr) {
        double midLat = (highLat - lowLat) / 2.0 + lowLat;
        double midLatDist = this.ctx.getDistCalc().distance(ctr, lon, midLat);
        for (int L = 0; L < 100 && (highLat - lowLat > 0.001 || L < 20); ++L) {
            boolean bottom = midLat - lowLat > highLat - midLat;
            double newMid = bottom ? (midLat - lowLat) / 2.0 + lowLat : (highLat - midLat) / 2.0 + midLat;
            double newMidDist = this.ctx.getDistCalc().distance(ctr, lon, newMid);
            if (newMidDist < midLatDist) {
                if (bottom) {
                    highLat = midLat;
                } else {
                    lowLat = midLat;
                }
                midLat = newMid;
                midLatDist = newMidDist;
                continue;
            }
            if (bottom) {
                lowLat = newMid;
                continue;
            }
            highLat = newMid;
        }
        return this.ctx.makePoint(lon, midLat);
    }

    @Test
    public void testDistCalcPointOnBearing_cartesian() {
        this.ctx = new SpatialContext(false);
        this.EPS = 1.0E-5;
        for (int i = 0; i < 1000; ++i) {
            this.testDistCalcPointOnBearing(TestDistances.randomInt((int)100));
        }
    }

    @Test
    public void testDistCalcPointOnBearing_geo() {
        double maxDistKm = 20015.114352186374;
        for (int i = 0; i < 1000; ++i) {
            int distKm = TestDistances.randomInt((int)((int)maxDistKm));
            this.EPS = (double)distKm < maxDistKm * 0.75 ? 1.0E-5 : 0.01;
            this.testDistCalcPointOnBearing(distKm);
        }
    }

    private void testDistCalcPointOnBearing(double distKm) {
        for (int angDEG = 0; angDEG < 360; angDEG += TestDistances.randomIntBetween((int)1, (int)20)) {
            Point c = this.ctx.makePoint(DistanceUtils.normLonDEG((double)TestDistances.randomInt((int)359)), (double)TestDistances.randomIntBetween((int)-90, (int)90));
            Point p2 = this.dc().pointOnBearing(c, 0.0, (double)angDEG, this.ctx, null);
            TestDistances.assertEquals((Object)c, (Object)p2);
            p2 = this.dc().pointOnBearing(c, distKm * 0.008993203677616635, (double)angDEG, this.ctx, null);
            double calcDistKm = this.dc().distance(c, p2) * 111.19507973436875;
            this.assertEqualsRatio(distKm, calcDistKm);
        }
    }

    private void assertEqualsRatio(double expected, double actual) {
        double delta = Math.abs(actual - expected);
        double base = Math.min(actual, expected);
        double deltaRatio = base == 0.0 ? delta : Math.min(delta, delta / base);
        TestDistances.assertEquals((double)0.0, (double)deltaRatio, (double)this.EPS);
    }

    @Test
    public void testNormLat() {
        double[][] lats;
        for (double[] pair : lats = new double[][]{{1.23, 1.23}, {-90.0, -90.0}, {90.0, 90.0}, {0.0, 0.0}, {-100.0, -80.0}, {-270.0, 90.0}, {-450.0, -90.0}, {270.0, -90.0}, {450.0, 90.0}, {168.0, 12.0}}) {
            TestDistances.assertEquals((String)("input " + pair[0]), (double)pair[1], (double)DistanceUtils.normLatDEG((double)pair[0]), (double)0.0);
        }
        for (int i = -1000; i < 1000; i += TestDistances.randomInt((int)9) * 10) {
            double d = DistanceUtils.normLatDEG((double)i);
            TestDistances.assertTrue((String)(i + " " + d), (d >= -90.0 && d <= 90.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNormLon() {
        double[][] lons;
        for (double[] pair : lons = new double[][]{{1.23, 1.23}, {-180.0, -180.0}, {180.0, 180.0}, {0.0, 0.0}, {-190.0, 170.0}, {181.0, -179.0}, {-540.0, -180.0}, {-900.0, -180.0}, {540.0, 180.0}, {900.0, 180.0}}) {
            TestDistances.assertEquals((String)("input " + pair[0]), (double)pair[1], (double)DistanceUtils.normLonDEG((double)pair[0]), (double)0.0);
        }
        for (int i = -1000; i < 1000; i += TestDistances.randomInt((int)9) * 10) {
            double d = DistanceUtils.normLonDEG((double)i);
            TestDistances.assertTrue((String)(i + " " + d), (d >= -180.0 && d <= 180.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void assertDistanceConversion() {
        this.assertDistanceConversion(0.0);
        this.assertDistanceConversion(500.0);
        this.assertDistanceConversion(6371.0087714);
    }

    private void assertDistanceConversion(double dist) {
        double radius = 6371.0087714;
        double distRAD = DistanceUtils.dist2Radians((double)dist, (double)radius);
        TestDistances.assertEquals((double)dist, (double)DistanceUtils.radians2Dist((double)distRAD, (double)radius), (double)this.EPS);
        double distDEG = DistanceUtils.dist2Degrees((double)dist, (double)radius);
        TestDistances.assertEquals((double)dist, (double)DistanceUtils.degrees2Dist((double)distDEG, (double)radius), (double)this.EPS);
        TestDistances.assertEquals((double)distDEG, (double)DistanceUtils.toDegrees((double)distRAD), (double)this.EPS);
        TestDistances.assertEquals((double)DistanceUtils.pointOnBearingRAD((double)0.0, (double)0.0, (double)DistanceUtils.dist2Radians((double)dist, (double)radius), (double)1.5707963267948966, (SpatialContext)this.ctx, (Point)new PointImpl(0.0, 0.0, this.ctx)).getX(), (double)distRAD, (double)1.0E-4);
    }

    private Point pLL(double lat, double lon) {
        return this.ctx.makePoint(lon, lat);
    }

    @Test
    public void testArea() {
        double radius = 57.295779513082316;
        double earthArea = Math.PI * 4 * radius * radius;
        Circle c = this.ctx.makeCircle((double)TestDistances.randomIntBetween((int)-180, (int)180), (double)TestDistances.randomIntBetween((int)-90, (int)90), 180.0);
        TestDistances.assertEquals((double)earthArea, (double)c.getArea(this.ctx), (double)1.0);
        TestDistances.assertEquals((double)earthArea, (double)this.ctx.getWorldBounds().getArea(this.ctx), (double)1.0);
        Circle cHalf = this.ctx.makeCircle(c.getCenter(), 90.0);
        TestDistances.assertEquals((double)(earthArea / 2.0), (double)cHalf.getArea(this.ctx), (double)1.0);
        Circle c2 = this.ctx.makeCircle(c.getCenter(), 30.0);
        Circle c3 = this.ctx.makeCircle(c.getCenter().getX(), 20.0, 30.0);
        TestDistances.assertEquals((double)c2.getArea(this.ctx), (double)c3.getArea(this.ctx), (double)0.01);
        Circle c3Opposite = this.ctx.makeCircle(c.getCenter().getX(), -20.0, 30.0);
        TestDistances.assertEquals((double)c3.getArea(this.ctx), (double)c3Opposite.getArea(this.ctx), (double)0.01);
        TestDistances.assertEquals((double)c3.getBoundingBox().getArea(this.ctx), (double)c3Opposite.getBoundingBox().getArea(this.ctx), (double)0.01);
        Rectangle smallRect = this.ctx.makeRectangle(0.0, 1.0, 0.0, 1.0);
        TestDistances.assertEquals((double)1.0, (double)smallRect.getArea(null), (double)0.0);
        double smallDelta = smallRect.getArea(null) - smallRect.getArea(this.ctx);
        TestDistances.assertTrue((smallDelta > 0.0 && smallDelta < 1.0E-4 ? 1 : 0) != 0);
        Circle smallCircle = this.ctx.makeCircle(0.0, 0.0, 1.0);
        smallDelta = smallCircle.getArea(null) - smallCircle.getArea(this.ctx);
        TestDistances.assertTrue((smallDelta > 0.0 && smallDelta < 1.0E-4 ? 1 : 0) != 0);
        double areaRatio = c2.getArea(null) / c2.getArea(this.ctx);
        TestDistances.assertTrue((areaRatio > 1.0 && areaRatio < 1.1 ? 1 : 0) != 0);
    }
}

