/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.context.jts.ValidationRule;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.io.jts.JtsWKTReader;
import com.spatial4j.core.shape.impl.RectangleImpl;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SpatialContextFactoryTest {
    public static final String PROP = "SpatialContextFactory";

    @After
    public void tearDown() {
        System.getProperties().remove(PROP);
    }

    private SpatialContext call(String ... argsStr) {
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < argsStr.length; i += 2) {
            String key = argsStr[i];
            String val = argsStr[i + 1];
            args.put(key, val);
        }
        return SpatialContextFactory.makeSpatialContext(args, (ClassLoader)this.getClass().getClassLoader());
    }

    @Test
    public void testDefault() {
        SpatialContext ctx = SpatialContext.GEO;
        SpatialContext ctx2 = this.call(new String[0]);
        Assert.assertEquals(ctx.getClass(), ctx2.getClass());
        Assert.assertEquals((Object)ctx.isGeo(), (Object)ctx2.isGeo());
        Assert.assertEquals((Object)ctx.getDistCalc(), (Object)ctx2.getDistCalc());
        Assert.assertEquals((Object)ctx.getWorldBounds(), (Object)ctx2.getWorldBounds());
    }

    @Test
    public void testCustom() {
        SpatialContext ctx = this.call("geo", "false");
        Assert.assertTrue((!ctx.isGeo() ? 1 : 0) != 0);
        Assert.assertEquals((Object)new CartesianDistCalc(), (Object)ctx.getDistCalc());
        ctx = this.call("geo", "false", "distCalculator", "cartesian^2", "worldBounds", "ENVELOPE(-100, 75, 200, 0)");
        Assert.assertEquals((Object)new CartesianDistCalc(true), (Object)ctx.getDistCalc());
        Assert.assertEquals((Object)new RectangleImpl(-100.0, 75.0, 0.0, 200.0, ctx), (Object)ctx.getWorldBounds());
        ctx = this.call("geo", "true", "distCalculator", "lawOfCosines");
        Assert.assertTrue((boolean)ctx.isGeo());
        Assert.assertEquals((Object)new GeodesicSphereDistCalc.LawOfCosines(), (Object)ctx.getDistCalc());
    }

    @Test
    public void testJtsContextFactory() {
        JtsSpatialContext ctx = (JtsSpatialContext)this.call("spatialContextFactory", JtsSpatialContextFactory.class.getName(), "geo", "true", "normWrapLongitude", "true", "precisionScale", "2.0", "wktShapeParserClass", CustomWktShapeParser.class.getName(), "datelineRule", "ccwRect", "validationRule", "repairConvexHull", "autoIndex", "true");
        Assert.assertTrue((boolean)ctx.isNormWrapLongitude());
        Assert.assertEquals((double)2.0, (double)ctx.getGeometryFactory().getPrecisionModel().getScale(), (double)0.0);
        Assert.assertTrue((boolean)CustomWktShapeParser.once);
        Assert.assertEquals((Object)DatelineRule.ccwRect, (Object)ctx.getDatelineRule());
        Assert.assertEquals((Object)ValidationRule.repairConvexHull, (Object)ctx.getValidationRule());
        ctx = (JtsSpatialContext)this.call("spatialContextFactory", JtsSpatialContextFactory.class.getName(), "geo", "false", "worldBounds", "ENVELOPE(-500,500,300,-300)", "normWrapLongitude", "true", "precisionScale", "2.0", "wktShapeParserClass", CustomWktShapeParser.class.getName(), "datelineRule", "ccwRect", "validationRule", "repairConvexHull", "autoIndex", "true");
        Assert.assertEquals((double)300.0, (double)ctx.getWorldBounds().getMaxY(), (double)0.0);
    }

    @Test
    public void testFormatsConfig() {
        JtsSpatialContext ctx = (JtsSpatialContext)this.call("spatialContextFactory", JtsSpatialContextFactory.class.getName(), "readers", CustomWktShapeParser.class.getName());
        Assert.assertTrue((boolean)(ctx.getFormats().getReader("WKT") instanceof CustomWktShapeParser));
    }

    @Test
    public void testSystemPropertyLookup() {
        System.setProperty(PROP, DSCF.class.getName());
        Assert.assertTrue((!this.call(new String[0]).isGeo() ? 1 : 0) != 0);
    }

    public static class CustomWktShapeParser
    extends JtsWKTReader {
        static boolean once = false;

        public CustomWktShapeParser(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
            super(ctx, factory);
            once = true;
        }
    }

    public static class DSCF
    extends SpatialContextFactory {
        public SpatialContext newSpatialContext() {
            this.geo = false;
            return new SpatialContext((SpatialContextFactory)this);
        }
    }
}

