/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core;

import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.helpers.MessageFormatter;

public class TestLog
extends TestRuleAdapter {
    private static ArrayList<LogEntry> logStack = new ArrayList();
    private static final int MAX_LOGS = 1000;
    public static final TestLog instance = new TestLog();

    private TestLog() {
    }

    protected void before() throws Throwable {
        logStack.clear();
    }

    protected void afterAlways(List<Throwable> errors) throws Throwable {
        if (!errors.isEmpty()) {
            this.logThenClear();
        }
    }

    private void logThenClear() {
        for (LogEntry entry : logStack) {
            System.out.println(MessageFormatter.arrayFormat((String)entry.msg, (Object[])entry.args).getMessage());
        }
        logStack.clear();
    }

    public static void clear() {
        logStack.clear();
    }

    public static void log(String msg, Object ... args) {
        if (logStack.size() > 1000) {
            throw new RuntimeException("Too many log statements: " + logStack.size() + " > " + 1000);
        }
        LogEntry entry = new LogEntry();
        entry.msg = msg;
        entry.args = args;
        logStack.add(entry);
    }

    private static class LogEntry {
        String msg;
        Object[] args;

        private LogEntry() {
        }
    }
}

