/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int capacity) {
        if (buffer == null || buffer.capacity() < capacity) {
            buffer = ByteBuffer.allocate(capacity);
        }
        return buffer;
    }

    public static CharBuffer ensureCapacity(CharBuffer buffer, int capacity) {
        if (buffer == null || buffer.capacity() < capacity) {
            buffer = CharBuffer.allocate(capacity);
        }
        return buffer;
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        buffer = buffer.slice();
        byte[] buf = new byte[buffer.remaining()];
        buffer.get(buf);
        return new String(buf, charset);
    }

    public static byte[] toArray(ByteBuffer buffer) {
        byte[] dst = new byte[buffer.remaining()];
        buffer.mark();
        buffer.get(dst);
        buffer.reset();
        return dst;
    }

    static int sharedPrefixLength(ByteBuffer a, int aStart, ByteBuffer b, int bStart) {
        int i;
        int max = Math.min(a.remaining() - aStart, b.remaining() - bStart);
        aStart += a.position();
        bStart += b.position();
        for (i = 0; i < max && a.get(aStart++) == b.get(bStart++); ++i) {
        }
        return i;
    }

    static int sharedPrefixLength(ByteBuffer a, ByteBuffer b) {
        return BufferUtils.sharedPrefixLength(a, 0, b, 0);
    }
}

