/// <reference path="../node_modules/zarro/types.d.ts" />
(function () {
    // TypeScript local tasks must be wrapped in a closure to prevent multiple
    //   requireModule<T>(...) calls from clashing with each other in TS-land.
    //   This is not a requirement if you're creating a JavaScript task, but then
    //   you'd lose out on all the TS goodies :D
    // TypeScript tasks will be transpiled for you when zarro runs, with a
    //   .generated.js extension. You do not need to transpile anything yourself.
    const gulp = requireModule("gulp"), env = requireModule("env");
    /*
    *   requireModule<T>() is available within any zarro task file
    *   so you can easily get ahold of modules used within zarro.
    *
    *   apart from the obvious use-cases (eg you want to write your
    *   own specialized pipeline, but still use the wrapper functions
    *   for dotnet (requireModule<DotNetCli("dotnet-cli")), there are
    *   many utilities within zarro which can make task development
    *   easier. Check out:
    *   - System ("system")
    *     - powerful system command runner, providing optional callbacks
    *       for IO handling, or simply returning the IO and exit code
    *   - Exec ("exec")
    *     - simple executor wrapping system, returns stdout as a string
    *   - PromisifyStream ("promisify-stream" or "promisify")
    *     - converts a stream (eg gulp.src(...)...) to an awaitable
    *       promise
    *   - AnsiColors ("ansi-colors")
    *     - typed provider for "ansi-colors" module to colorise output
    *
    *   in addition, there are other modules installed as runtime
    *   dependencies for zarro which are found on npm and may be useful:
    *   - yafs
    *   - debug
    *   - npm-run-all, providing:
    *       - run-s: runs npm scripts in series
    *       - run-p: runs npm scripts in parallel
    *   - simple-git
    *   - and stream/gulp things like through2
    *
    *   if you're new to zarro, you may want to check out example
    *   usage in these projects:
    *   https://github.com/fluffynuts/
    *       - diff-buddy (example of "batteries-included" near-zero-conf)
    *       - NExpect
    *       - PeanutButter
    *       - newts
    */
    /*
    * OPTIONAL:
    *   Register environment variables that relate to your task
    *     via env.associate(...) so that 'zarro --show-env' will include
    *     information about the association, so consumers can tell
    *     which environment variables affect which tasks
    */
    env.associate([
        env.DRY_RUN
    ], [
        "this-is-an-example"
    ]);
    gulp.task("this-is-an-example", async () => {
        // you can surface this task to be run as 'npm run this-is-an-example'
        // by adding this to your scripts section in package.json
        // "this-is-an-example": "zarro @",
        // to make invocations faster, it's recommended
        // to require as much as possible locally (ie inside the task
        // or called functions) as this will mean that these modules
        // would only have to be fully resolved when actually necessary
        const system = requireModule("system"), systemResult = await system("whoami", [], { suppressOutput: true });
        console.log(`'whoami' from system() reports the current user is: ${systemResult.stdout[0]}`);
        // exec is a convenience wrapper around system, for light / quick calls
        const exec = requireModule("exec"), execResult = await exec("whoami");
        console.log(`'whoami' from exec() reports the current user is: ${execResult}`);
        console.log({
            label: "is this a dry run?",
            result: env.resolveFlag(env.DRY_RUN)
        });
        console.log("running skeleton task: this-is-an-example: ");
        return Promise.resolve();
    });
})();
