/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverInterceptor;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverStringSubstitutor;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolvers;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Uris;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.util.Strings;

@Configurable(elementType="layout")
@Plugin
public class JsonTemplateLayout
implements StringLayout {
    private static final Map<String, String> CONTENT_FORMAT = Collections.singletonMap("version", "1");
    private final Charset charset;
    private final String contentType;
    private final TemplateResolver<LogEvent> eventResolver;
    private final String eventDelimiter;
    private final Recycler<Context> contextRecycler;

    private JsonTemplateLayout(Builder builder) {
        this.charset = builder.charset;
        this.contentType = "application/json; charset=" + this.charset;
        String eventDelimiterSuffix = builder.isNullEventDelimiterEnabled() ? "\u0000" : "";
        this.eventDelimiter = builder.eventDelimiter + eventDelimiterSuffix;
        Configuration configuration = builder.configuration;
        JsonWriter jsonWriter = JsonWriter.newBuilder().setMaxStringLength(builder.maxStringLength).setTruncatedStringSuffix(builder.truncatedStringSuffix).build();
        this.eventResolver = this.createEventResolver(builder, configuration, this.charset, jsonWriter);
        this.contextRecycler = JsonTemplateLayout.createContextRecycler(builder, jsonWriter);
    }

    private TemplateResolver<LogEvent> createEventResolver(Builder builder, Configuration configuration, Charset charset, JsonWriter jsonWriter) {
        List resolverFactories = (List)configuration.getComponent((Key)new Key<List<EventResolverFactory>>(){});
        Map resolverFactoryByName = resolverFactories.stream().collect(Collectors.toMap(TemplateResolverFactory::getName, Function.identity(), (factory, conflictingFactory) -> {
            String message = String.format("found resolver factories with overlapping names: %s (%s and %s)", factory.getName(), conflictingFactory, factory);
            throw new IllegalArgumentException(message);
        }, LinkedHashMap::new));
        List resolverInterceptors = (List)configuration.getComponent((Key)new Key<List<EventResolverInterceptor>>(){});
        EventResolverStringSubstitutor substitutor = new EventResolverStringSubstitutor(configuration.getStrSubstitutor());
        String eventTemplate = JsonTemplateLayout.readEventTemplate(builder);
        String stackTraceElementTemplate = JsonTemplateLayout.readStackTraceElementTemplate(builder);
        float maxByteCountPerChar = builder.charset.newEncoder().maxBytesPerChar();
        int maxStringByteCount = Math.toIntExact(Math.round(Math.ceil(maxByteCountPerChar * (float)builder.maxStringLength)));
        EventTemplateAdditionalField[] eventTemplateAdditionalFields = builder.eventTemplateAdditionalFields != null ? builder.eventTemplateAdditionalFields : new EventTemplateAdditionalField[]{};
        EventResolverContext resolverContext = EventResolverContext.newBuilder().setConfiguration(configuration).setResolverFactoryByName(resolverFactoryByName).setResolverInterceptors(resolverInterceptors).setSubstitutor(substitutor).setCharset(charset).setJsonWriter(jsonWriter).setMaxStringByteCount(maxStringByteCount).setTruncatedStringSuffix(builder.truncatedStringSuffix).setLocationInfoEnabled(builder.locationInfoEnabled).setStackTraceEnabled(builder.stackTraceEnabled).setStackTraceElementTemplate(stackTraceElementTemplate).setEventTemplateRootObjectKey(builder.eventTemplateRootObjectKey).setEventTemplateAdditionalFields(eventTemplateAdditionalFields).build();
        return TemplateResolvers.ofTemplate(resolverContext, eventTemplate);
    }

    private static String readEventTemplate(Builder builder) {
        return JsonTemplateLayout.readTemplate(builder.eventTemplate, builder.eventTemplateUri, builder.charset);
    }

    private static String readStackTraceElementTemplate(Builder builder) {
        return JsonTemplateLayout.readTemplate(builder.stackTraceElementTemplate, builder.stackTraceElementTemplateUri, builder.charset);
    }

    private static String readTemplate(String template, String templateUri, Charset charset) {
        return Strings.isBlank((String)template) ? Uris.readUri(templateUri, charset) : template;
    }

    private static Recycler<Context> createContextRecycler(Builder builder, JsonWriter jsonWriter) {
        Supplier<Context> supplier = JsonTemplateLayout.createContextSupplier(builder.charset, jsonWriter);
        return builder.configuration.getRecyclerFactory().create(supplier, Context::close);
    }

    private static Supplier<Context> createContextSupplier(Charset charset, JsonWriter jsonWriter) {
        return () -> {
            JsonWriter clonedJsonWriter = jsonWriter.clone();
            StringBuilderEncoder encoder = new StringBuilderEncoder(charset);
            return new Context(clonedJsonWriter, (Encoder<StringBuilder>)encoder);
        };
    }

    public byte[] toByteArray(LogEvent event) {
        String eventJson = this.toSerializable(event);
        if (eventJson != null) {
            return eventJson.getBytes(this.charset != null ? this.charset : Charset.defaultCharset());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializable(LogEvent event) {
        Recycler<Context> contextRecycler = this.contextRecycler;
        Context context = (Context)contextRecycler.acquire();
        JsonWriter jsonWriter = context.jsonWriter;
        StringBuilder stringBuilder = jsonWriter.getStringBuilder();
        try {
            this.eventResolver.resolve(event, jsonWriter);
            stringBuilder.append(this.eventDelimiter);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            contextRecycler.release((Object)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(LogEvent event, ByteBufferDestination destination) {
        Recycler<Context> contextRecycler = this.contextRecycler;
        Context context = (Context)contextRecycler.acquire();
        JsonWriter jsonWriter = context.jsonWriter;
        StringBuilder stringBuilder = jsonWriter.getStringBuilder();
        Encoder<StringBuilder> encoder = context.encoder;
        try {
            this.eventResolver.resolve(event, jsonWriter);
            stringBuilder.append(this.eventDelimiter);
            encoder.encode((Object)stringBuilder, destination);
        }
        finally {
            contextRecycler.release((Object)context);
        }
    }

    public byte[] getFooter() {
        return null;
    }

    public byte[] getHeader() {
        return null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getContentFormat() {
        return CONTENT_FORMAT;
    }

    @Factory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<JsonTemplateLayout> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        private Charset charset = JsonTemplateLayoutDefaults.getCharset();
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = JsonTemplateLayoutDefaults.isLocationInfoEnabled();
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = JsonTemplateLayoutDefaults.isStackTraceEnabled();
        @PluginBuilderAttribute
        private String eventTemplate = JsonTemplateLayoutDefaults.getEventTemplate();
        @PluginBuilderAttribute
        private String eventTemplateUri = JsonTemplateLayoutDefaults.getEventTemplateUri();
        @PluginBuilderAttribute
        private String eventTemplateRootObjectKey = JsonTemplateLayoutDefaults.getEventTemplateRootObjectKey();
        @PluginElement(value="EventTemplateAdditionalField")
        private @PluginElement(value="EventTemplateAdditionalField") EventTemplateAdditionalField[] eventTemplateAdditionalFields;
        @PluginBuilderAttribute
        private String stackTraceElementTemplate = JsonTemplateLayoutDefaults.getStackTraceElementTemplate();
        @PluginBuilderAttribute
        private String stackTraceElementTemplateUri = JsonTemplateLayoutDefaults.getStackTraceElementTemplateUri();
        @PluginBuilderAttribute
        private String eventDelimiter = JsonTemplateLayoutDefaults.getEventDelimiter();
        @PluginBuilderAttribute
        private boolean nullEventDelimiterEnabled = JsonTemplateLayoutDefaults.isNullEventDelimiterEnabled();
        @PluginBuilderAttribute
        private int maxStringLength = JsonTemplateLayoutDefaults.getMaxStringLength();
        @PluginBuilderAttribute
        private String truncatedStringSuffix = JsonTemplateLayoutDefaults.getTruncatedStringSuffix();

        private Builder() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public String getEventTemplate() {
            return this.eventTemplate;
        }

        public Builder setEventTemplate(String eventTemplate) {
            this.eventTemplate = eventTemplate;
            return this;
        }

        public String getEventTemplateUri() {
            return this.eventTemplateUri;
        }

        public Builder setEventTemplateUri(String eventTemplateUri) {
            this.eventTemplateUri = eventTemplateUri;
            return this;
        }

        public String getEventTemplateRootObjectKey() {
            return this.eventTemplateRootObjectKey;
        }

        public Builder setEventTemplateRootObjectKey(String eventTemplateRootObjectKey) {
            this.eventTemplateRootObjectKey = eventTemplateRootObjectKey;
            return this;
        }

        public EventTemplateAdditionalField[] getEventTemplateAdditionalFields() {
            return this.eventTemplateAdditionalFields;
        }

        public Builder setEventTemplateAdditionalFields(EventTemplateAdditionalField[] eventTemplateAdditionalFields) {
            this.eventTemplateAdditionalFields = eventTemplateAdditionalFields;
            return this;
        }

        public String getStackTraceElementTemplate() {
            return this.stackTraceElementTemplate;
        }

        public Builder setStackTraceElementTemplate(String stackTraceElementTemplate) {
            this.stackTraceElementTemplate = stackTraceElementTemplate;
            return this;
        }

        public String getStackTraceElementTemplateUri() {
            return this.stackTraceElementTemplateUri;
        }

        public Builder setStackTraceElementTemplateUri(String stackTraceElementTemplateUri) {
            this.stackTraceElementTemplateUri = stackTraceElementTemplateUri;
            return this;
        }

        public String getEventDelimiter() {
            return this.eventDelimiter;
        }

        public Builder setEventDelimiter(String eventDelimiter) {
            this.eventDelimiter = eventDelimiter;
            return this;
        }

        public boolean isNullEventDelimiterEnabled() {
            return this.nullEventDelimiterEnabled;
        }

        public Builder setNullEventDelimiterEnabled(boolean nullEventDelimiterEnabled) {
            this.nullEventDelimiterEnabled = nullEventDelimiterEnabled;
            return this;
        }

        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        public Builder setMaxStringLength(int maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public String getTruncatedStringSuffix() {
            return this.truncatedStringSuffix;
        }

        public Builder setTruncatedStringSuffix(String truncatedStringSuffix) {
            this.truncatedStringSuffix = truncatedStringSuffix;
            return this;
        }

        public JsonTemplateLayout build() {
            this.validate();
            return new JsonTemplateLayout(this);
        }

        private void validate() {
            Objects.requireNonNull(this.configuration, "configuration");
            if (Strings.isBlank((String)this.eventTemplate) && Strings.isBlank((String)this.eventTemplateUri)) {
                throw new IllegalArgumentException("both eventTemplate and eventTemplateUri are blank");
            }
            if (this.stackTraceEnabled && Strings.isBlank((String)this.stackTraceElementTemplate) && Strings.isBlank((String)this.stackTraceElementTemplateUri)) {
                throw new IllegalArgumentException("both stackTraceElementTemplate and stackTraceElementTemplateUri are blank");
            }
            if (this.maxStringLength <= 0) {
                throw new IllegalArgumentException("was expecting a non-zero positive maxStringLength: " + this.maxStringLength);
            }
            Objects.requireNonNull(this.truncatedStringSuffix, "truncatedStringSuffix");
        }
    }

    @Configurable(printObject=true)
    @Plugin(value="EventTemplateAdditionalField")
    public static final class EventTemplateAdditionalField {
        private final String key;
        private final String value;
        private final Format format;

        private EventTemplateAdditionalField(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
            this.format = builder.format;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Format getFormat() {
            return this.format;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EventTemplateAdditionalField that = (EventTemplateAdditionalField)object;
            return this.key.equals(that.key) && this.value.equals(that.value) && this.format == that.format;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.value, this.format});
        }

        public String toString() {
            String formattedValue = Format.STRING.equals((Object)this.format) ? String.format("\"%s\"", this.value) : this.value;
            return String.format("%s=%s", this.key, formattedValue);
        }

        @Factory
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder
        implements org.apache.logging.log4j.plugins.util.Builder<EventTemplateAdditionalField> {
            @PluginBuilderAttribute
            private String key;
            @PluginBuilderAttribute
            private String value;
            @PluginBuilderAttribute
            private Format format = Format.STRING;

            public Builder setKey(String key) {
                this.key = key;
                return this;
            }

            public Builder setValue(String value) {
                this.value = value;
                return this;
            }

            public Builder setFormat(Format format) {
                this.format = format;
                return this;
            }

            public EventTemplateAdditionalField build() {
                this.validate();
                return new EventTemplateAdditionalField(this);
            }

            private void validate() {
                if (Strings.isBlank((String)this.key)) {
                    throw new IllegalArgumentException("blank key");
                }
                if (Strings.isBlank((String)this.value)) {
                    throw new IllegalArgumentException("blank value");
                }
                Objects.requireNonNull(this.format, "format");
            }
        }

        public static enum Format {
            STRING,
            JSON;

        }
    }

    private static final class Context
    implements AutoCloseable {
        final JsonWriter jsonWriter;
        final Encoder<StringBuilder> encoder;

        private Context(JsonWriter jsonWriter, Encoder<StringBuilder> encoder) {
            this.jsonWriter = jsonWriter;
            this.encoder = encoder;
        }

        @Override
        public void close() {
            this.jsonWriter.close();
        }
    }
}

