/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import com.lmax.disruptor.EventFactory;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.async.logger.AsyncLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.ReusableLogEvent;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MementoMessage;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterConsumer;
import org.apache.logging.log4j.message.ParameterVisitable;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.StringMap;

public class RingBufferLogEvent
implements ReusableLogEvent,
ReusableMessage,
CharSequence,
ParameterVisitable {
    public static final EventFactory<RingBufferLogEvent> FACTORY = new Factory();
    private static final Message EMPTY = new SimpleMessage("");
    private boolean populated;
    private int threadPriority;
    private long threadId;
    private final MutableInstant instant = new MutableInstant();
    private long nanoTime;
    private short parameterCount;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private Level level;
    private String threadName;
    private String loggerName;
    private Message message;
    private String messageFormat;
    private StringBuilder messageText;
    private Object[] parameters;
    private Throwable thrown;
    private ThrowableProxy thrownProxy;
    private StringMap contextData = ContextDataFactory.createContextData();
    private Marker marker;
    private String fqcn;
    private StackTraceElement location;
    private ThreadContext.ContextStack contextStack;
    private AsyncLogger asyncLogger;

    public void setValues(AsyncLogger anAsyncLogger, String aLoggerName, Marker aMarker, String theFqcn, Level aLevel, Message msg, Throwable aThrowable, StringMap mutableContextData, ThreadContext.ContextStack aContextStack, long threadId, String threadName, int threadPriority, StackTraceElement aLocation, Clock clock, NanoClock nanoClock) {
        this.threadPriority = threadPriority;
        this.threadId = threadId;
        this.level = aLevel;
        this.threadName = threadName;
        this.loggerName = aLoggerName;
        this.setMessage(msg);
        this.initTime(clock);
        this.nanoTime = nanoClock.nanoTime();
        this.thrown = aThrowable;
        this.thrownProxy = null;
        this.marker = aMarker;
        this.fqcn = theFqcn;
        this.location = aLocation;
        this.contextData = mutableContextData;
        this.contextStack = aContextStack;
        this.asyncLogger = anAsyncLogger;
        this.populated = true;
    }

    private void initTime(Clock clock) {
        if (this.message instanceof TimestampMessage) {
            this.instant.initFromEpochMilli(((TimestampMessage)this.message).getTimestamp(), 0);
        } else {
            this.instant.initFrom(clock);
        }
    }

    public LogEvent toImmutable() {
        return this.toMemento();
    }

    public void setMessage(Message msg) {
        if (msg instanceof ReusableMessage) {
            ReusableMessage reusable = (ReusableMessage)msg;
            reusable.formatTo(this.getMessageTextForWriting());
            this.messageFormat = reusable.getFormat();
            this.parameters = reusable.swapParameters(this.parameters == null ? new Object[10] : this.parameters);
            this.parameterCount = reusable.getParameterCount();
        } else {
            this.message = InternalAsyncUtil.makeMessageImmutable((Message)msg);
        }
    }

    private StringBuilder getMessageTextForWriting() {
        if (this.messageText == null) {
            this.messageText = new StringBuilder(Constants.INITIAL_REUSABLE_MESSAGE_SIZE);
        }
        this.messageText.setLength(0);
        return this.messageText;
    }

    public void execute(boolean endOfBatch) {
        this.endOfBatch = endOfBatch;
        this.asyncLogger.actualAsyncLog(this);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    public void setEndOfBatch(boolean endOfBatch) {
        this.endOfBatch = endOfBatch;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public String getLoggerFqcn() {
        return this.fqcn;
    }

    public void setLoggerFqcn(String loggerFqcn) {
        this.fqcn = loggerFqcn;
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = Level.OFF;
        }
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Message getMessage() {
        if (this.message == null) {
            return this.messageText == null ? EMPTY : this;
        }
        return this.message;
    }

    public String getFormattedMessage() {
        return this.messageText != null ? this.messageText.toString() : (this.message == null ? null : this.message.getFormattedMessage());
    }

    public String getFormat() {
        return this.messageFormat;
    }

    public Object[] getParameters() {
        return this.parameters == null ? null : Arrays.copyOf(this.parameters, (int)this.parameterCount);
    }

    public Throwable getThrowable() {
        return this.getThrown();
    }

    public void formatTo(StringBuilder buffer) {
        buffer.append((CharSequence)this.messageText);
    }

    public Object[] swapParameters(Object[] emptyReplacement) {
        Object[] result = this.parameters;
        this.parameters = emptyReplacement;
        return result;
    }

    public short getParameterCount() {
        return this.parameterCount;
    }

    public <S> void forEachParameter(ParameterConsumer<S> action, S state) {
        if (this.parameters != null) {
            for (short i = 0; i < this.parameterCount; i = (short)(i + 1)) {
                action.accept(this.parameters[i], (int)i, state);
            }
        }
    }

    public Message memento() {
        if (this.message == null) {
            this.message = new MementoMessage(String.valueOf(this.messageText), this.messageFormat, this.getParameters());
        }
        return this.message;
    }

    @Override
    public int length() {
        return this.messageText.length();
    }

    @Override
    public char charAt(int index) {
        return this.messageText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.messageText.subSequence(start, end);
    }

    public Throwable getThrown() {
        if (this.thrown == null && this.thrownProxy != null) {
            this.thrown = this.thrownProxy.getThrowable();
        }
        return this.thrown;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }

    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    public StringMap getContextData() {
        return this.contextData;
    }

    public void setContextData(StringMap contextData) {
        this.contextData = contextData;
    }

    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    public void setContextStack(ThreadContext.ContextStack contextStack) {
        this.contextStack = contextStack;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public StackTraceElement getSource() {
        return this.location;
    }

    public void setSource(StackTraceElement source) {
        this.location = source;
    }

    public long getTimeMillis() {
        return this.message instanceof TimestampMessage ? ((TimestampMessage)this.message).getTimestamp() : this.instant.getEpochMillisecond();
    }

    public void setTimeMillis(long timeMillis) {
        this.instant.initFromEpochMilli(timeMillis, 0);
    }

    public Instant getInstant() {
        return this.instant;
    }

    public void setInstant(Instant instant) {
        this.instant.initFrom(instant);
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void setNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public void clear() {
        this.populated = false;
        this.level = null;
        this.threadName = null;
        this.loggerName = null;
        this.clearMessage();
        this.thrown = null;
        this.thrownProxy = null;
        this.clearContextData();
        this.marker = null;
        this.fqcn = null;
        this.location = null;
        this.contextStack = null;
        this.asyncLogger = null;
    }

    private void clearMessage() {
        this.message = null;
        this.messageFormat = null;
        StringBuilders.trimToMaxSize((StringBuilder)this.messageText, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        if (this.parameters != null) {
            Arrays.fill(this.parameters, null);
        }
    }

    private void clearContextData() {
        if (this.contextData != null) {
            if (this.contextData.isFrozen()) {
                this.contextData = null;
            } else {
                this.contextData.clear();
            }
        }
    }

    public void initializeBuilder(Log4jLogEvent.Builder builder) {
        StringMap oldContextData = this.contextData;
        StringMap contextData = oldContextData != null && !oldContextData.isFrozen() ? ContextDataFactory.createContextData((ReadOnlyStringMap)oldContextData) : oldContextData;
        builder.setContextData(contextData).setContextStack(this.contextStack).setEndOfBatch(this.endOfBatch).setIncludeLocation(this.includeLocation).setLevel(this.getLevel()).setLoggerFqcn(this.fqcn).setLoggerName(this.loggerName).setMarker(this.marker).setMessage(this.memento()).setNanoTime(this.nanoTime).setSource(this.location).setThreadId(this.threadId).setThreadName(this.threadName).setThreadPriority(this.threadPriority).setThrown(this.getThrown()).setThrownProxy(this.thrownProxy).setInstant((Instant)this.instant);
    }

    private static class Factory
    implements EventFactory<RingBufferLogEvent> {
        private Factory() {
        }

        public RingBufferLogEvent newInstance() {
            return new RingBufferLogEvent();
        }
    }
}

