/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.async.logger.AsyncLogger;
import org.apache.logging.log4j.async.logger.AsyncLoggerDisruptor;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.async.logger.DisruptorConfiguration;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class AsyncLoggerContext
extends LoggerContext {
    private final AsyncLoggerDisruptor loggerDisruptor;

    public AsyncLoggerContext(String name) {
        super(name);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    public AsyncLoggerContext(String name, Object externalContext) {
        super(name, externalContext);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    public AsyncLoggerContext(String name, Object externalContext, URI configLocn) {
        super(name, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    public AsyncLoggerContext(String name, Object externalContext, URI configLocn, ConfigurableInstanceFactory instanceFactory) {
        super(name, externalContext, configLocn, instanceFactory);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    public AsyncLoggerContext(String name, Object externalContext, String configLocn) {
        super(name, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    public AsyncLoggerContext(String name, Object externalContext, String configLocn, ConfigurableInstanceFactory instanceFactory) {
        super(name, externalContext, configLocn, instanceFactory);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, this::createAsyncWaitStrategyFactory);
    }

    private AsyncWaitStrategyFactory createAsyncWaitStrategyFactory() {
        DisruptorConfiguration disruptorConfiguration = (DisruptorConfiguration)this.getConfiguration().getExtension(DisruptorConfiguration.class);
        return disruptorConfiguration != null ? disruptorConfiguration.getWaitStrategyFactory() : null;
    }

    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        return new AsyncLogger(ctx, name, messageFactory, this.loggerDisruptor);
    }

    public void setName(String name) {
        super.setName("AsyncContext[" + name + "]");
        this.loggerDisruptor.setContextName(name);
    }

    public void start() {
        this.loggerDisruptor.start();
        super.start();
    }

    public void start(Configuration config) {
        this.maybeStartHelper(config);
        super.start(config);
    }

    private void maybeStartHelper(Configuration config) {
        if (config instanceof DefaultConfiguration) {
            StatusLogger.getLogger().debug("[{}] Not starting Disruptor for DefaultConfiguration.", (Object)this.getName());
        } else {
            this.loggerDisruptor.start();
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        this.loggerDisruptor.stop(timeout, timeUnit);
        super.stop(timeout, timeUnit);
        return true;
    }

    public boolean includeLocation() {
        return false;
    }

    AsyncLoggerDisruptor getAsyncLoggerDisruptor() {
        return this.loggerDisruptor;
    }
}

