/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.config.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.model.PluginType;

public abstract class AbstractJacksonConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private final List<Status> status = new ArrayList<Status>();
    private JsonNode root;

    public AbstractJacksonConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        super(loggerContext, configurationSource);
        try {
            byte[] buffer;
            try (InputStream configStream = configurationSource.getInputStream();){
                buffer = configStream.readAllBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            this.root = this.getObjectMapper().readTree((InputStream)is);
            if (this.root.size() == 1) {
                Iterator iterator = this.root.iterator();
                while (iterator.hasNext()) {
                    JsonNode node;
                    this.root = node = (JsonNode)iterator.next();
                }
            }
            this.processAttributes(this.rootNode, this.root);
            StatusConfiguration statusConfig = new StatusConfiguration().setStatus(this.getDefaultStatus());
            int monitorIntervalSeconds = 0;
            for (Map.Entry entry : this.rootNode.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getConfigurationStrSubstitutor().replace((String)entry.getValue());
                if ("status".equalsIgnoreCase(key)) {
                    statusConfig.setStatus(value);
                    continue;
                }
                if ("dest".equalsIgnoreCase(key)) {
                    statusConfig.setDestination(value);
                    continue;
                }
                if ("shutdownHook".equalsIgnoreCase(key)) {
                    this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(value);
                    continue;
                }
                if ("shutdownTimeout".equalsIgnoreCase(key)) {
                    this.shutdownTimeoutMillis = Long.parseLong(value);
                    continue;
                }
                if ("verbose".equalsIgnoreCase((String)entry.getKey())) {
                    statusConfig.setVerbosity(value);
                    continue;
                }
                if ("packages".equalsIgnoreCase(key)) {
                    LOGGER.warn("The packages attribute is no longer supported");
                    continue;
                }
                if ("name".equalsIgnoreCase(key)) {
                    this.setName(value);
                    continue;
                }
                if ("monitorInterval".equalsIgnoreCase(key)) {
                    monitorIntervalSeconds = Integer.parseInt(value);
                    continue;
                }
                if (!"advertiser".equalsIgnoreCase(key)) continue;
                this.createAdvertiser(value, configurationSource, buffer, "application/json");
            }
            this.initializeWatchers(this, configurationSource, monitorIntervalSeconds);
            statusConfig.initialize();
            if (this.getName() == null) {
                this.setName(configurationSource.getLocation());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing " + configurationSource.getLocation(), (Throwable)ex);
        }
    }

    protected abstract ObjectMapper getObjectMapper();

    protected abstract Configuration createConfiguration(LoggerContext var1, ConfigurationSource var2);

    public void setup() {
        Iterator iter = this.root.fields();
        List children = this.rootNode.getChildren();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            JsonNode n = (JsonNode)entry.getValue();
            if (n.isObject()) {
                LOGGER.debug("Processing node for object {}", entry.getKey());
                children.add(this.constructNode((String)entry.getKey(), this.rootNode, n));
                continue;
            }
            if (!n.isArray()) continue;
            LOGGER.error("Arrays are not supported at the root configuration.");
        }
        LOGGER.debug("Completed parsing configuration");
        if (this.status.size() > 0) {
            for (Status s : this.status) {
                LOGGER.error("Error processing element {}: {}", (Object)s.name, (Object)s.errorType);
            }
        }
    }

    public Configuration reconfigure() {
        try {
            ConfigurationSource source = this.getConfigurationSource().resetInputStream();
            if (source == null) {
                return null;
            }
            return this.createConfiguration(this.getLoggerContext(), source);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)ex);
            return null;
        }
    }

    private Node constructNode(String name, Node parent, JsonNode jsonNode) {
        PluginType type = this.corePlugins.get(this.getType(jsonNode, name));
        Node node = new Node(parent, name, type);
        this.processAttributes(node, jsonNode);
        Iterator iter = jsonNode.fields();
        List children = node.getChildren();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            JsonNode n = (JsonNode)entry.getValue();
            if (n.isArray() || n.isObject()) {
                if (type == null) {
                    this.status.add(new Status(name, n, ErrorType.CLASS_NOT_FOUND));
                }
                if (n.isArray()) {
                    LOGGER.debug("Processing node for array {}", entry.getKey());
                    for (int i = 0; i < n.size(); ++i) {
                        LOGGER.debug("Processing node for array entry {}[{}]", entry.getKey(), (Object)i);
                        children.add(this.constructNode((String)entry.getKey(), node, n.get(i)));
                    }
                    continue;
                }
                LOGGER.debug("Processing node for object {}", entry.getKey());
                children.add(this.constructNode((String)entry.getKey(), node, n));
                continue;
            }
            LOGGER.debug("Node {} is of type {}", entry.getKey(), (Object)n.getNodeType());
        }
        Object t = type == null ? "null" : type.getElementType() + ":" + type.getPluginClass();
        String p = node.getParent() == null ? "null" : (node.getParent().getName() == null ? "root" : node.getParent().getName());
        LOGGER.debug("Returning {} with parent {} of type {}", (Object)node.getName(), (Object)p, t);
        return node;
    }

    private String getType(JsonNode node, String name) {
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            JsonNode n;
            Map.Entry entry = (Map.Entry)iter.next();
            if (!"type".equalsIgnoreCase((String)entry.getKey()) || !(n = (JsonNode)entry.getValue()).isValueNode()) continue;
            return n.asText();
        }
        return name;
    }

    private void processAttributes(Node parent, JsonNode node) {
        Map attrs = parent.getAttributes();
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            JsonNode n;
            Map.Entry entry = (Map.Entry)iter.next();
            if ("type".equalsIgnoreCase((String)entry.getKey()) || !(n = (JsonNode)entry.getValue()).isValueNode()) continue;
            attrs.put((String)entry.getKey(), n.asText());
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }

    private static class Status {
        private final JsonNode node;
        private final String name;
        private final ErrorType errorType;

        public Status(String name, JsonNode node, ErrorType errorType) {
            this.name = name;
            this.node = node;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status [name=" + this.name + ", errorType=" + this.errorType + ", node=" + this.node + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }

    public static final class SortingNodeFactory
    extends JsonNodeFactory {
        public static final JsonNodeFactory INSTANCE = new SortingNodeFactory();

        private SortingNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

