/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.logging.log4j.jul.test;

import static org.junit.Assert.assertEquals;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

// @Category(AsyncLoggers.class)
@Ignore("https://issues.apache.org/jira/browse/LOG4J2-3523")
public class AsyncLoggerThreadsTest {

    @BeforeClass
    public static void beforeClass() {
        System.setProperty(
                Log4jPropertyKey.CONTEXT_SELECTOR_CLASS_NAME.getSystemKey(),
                AsyncLoggerContextSelector.class.getName());
        System.setProperty("java.util.logging.manager", LogManager.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty(Log4jPropertyKey.CONTEXT_SELECTOR_CLASS_NAME.getSystemKey());
        System.clearProperty("java.util.logging.manager");
    }

    @Test
    public void testAsyncLoggerThreads() {
        LogManager.getLogger("com.foo.Bar").info("log");
        final List<Thread> asyncLoggerThreads = Thread.getAllStackTraces().keySet().stream()
                .filter(thread -> thread.getName().matches("Log4j2-TF.*AsyncLogger.*"))
                .collect(Collectors.toList());
        assertEquals(asyncLoggerThreads.toString(), 1, asyncLoggerThreads.size());
    }
}
