/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web.appender;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

@Plugin(name="Servlet", category="Core", elementType="appender", printObject=true)
public class ServletAppender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    private final ServletContext servletContext;

    private ServletAppender(String name, AbstractStringLayout layout, Filter filter, ServletContext servletContext, boolean ignoreExceptions) {
        super(name, filter, (Layout)layout, ignoreExceptions);
        this.servletContext = servletContext;
    }

    public void append(LogEvent event) {
        this.servletContext.log((String)((Object)((AbstractStringLayout)this.getLayout()).toSerializable(event)));
    }

    @PluginFactory
    public static ServletAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="name") @Required(message="No name provided for ServletAppender") String name, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        ServletContext servletContext = WebLoggerContextUtils.getServletContext();
        if (servletContext == null) {
            LOGGER.error("No servlet context is available");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        } else if (!(layout instanceof AbstractStringLayout)) {
            LOGGER.error("Layout must be a StringLayout to log to ServletContext");
            return null;
        }
        return new ServletAppender(name, (AbstractStringLayout)layout, filter, servletContext, ignoreExceptions);
    }
}

