/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.taglib;

import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.taglib.Log4jTaglibLogger;

final class Log4jTaglibLoggerContext
implements LoggerContext {
    private static final WeakHashMap<ServletContext, Log4jTaglibLoggerContext> CONTEXTS = new WeakHashMap();
    private final WeakHashMap<String, Log4jTaglibLogger> loggers = new WeakHashMap();
    private final ServletContext servletContext;

    private Log4jTaglibLoggerContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object getExternalContext() {
        return this.servletContext;
    }

    public Log4jTaglibLogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log4jTaglibLogger getLogger(String name, MessageFactory factory) {
        Log4jTaglibLogger logger = this.loggers.get(name);
        if (logger != null) {
            AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)factory);
            return logger;
        }
        WeakHashMap<String, Log4jTaglibLogger> weakHashMap = this.loggers;
        synchronized (weakHashMap) {
            logger = this.loggers.get(name);
            if (logger == null) {
                LoggerContext context = LogManager.getContext((boolean)false);
                ExtendedLogger original = factory == null ? context.getLogger(name) : context.getLogger(name, factory);
                logger = new Log4jTaglibLogger(original, name, original.getMessageFactory());
                this.loggers.put(name, logger);
            }
        }
        return logger;
    }

    public boolean hasLogger(String name) {
        return this.loggers.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Log4jTaglibLoggerContext getInstance(ServletContext servletContext) {
        Log4jTaglibLoggerContext loggerContext = CONTEXTS.get(servletContext);
        if (loggerContext != null) {
            return loggerContext;
        }
        WeakHashMap<ServletContext, Log4jTaglibLoggerContext> weakHashMap = CONTEXTS;
        synchronized (weakHashMap) {
            loggerContext = CONTEXTS.get(servletContext);
            if (loggerContext == null) {
                loggerContext = new Log4jTaglibLoggerContext(servletContext);
                CONTEXTS.put(servletContext, loggerContext);
            }
        }
        return loggerContext;
    }
}

