/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.assertj.core.api.Assertions;

public final class GcFreeLoggingTestUtil
extends Enum<GcFreeLoggingTestUtil> {
    private static final /* synthetic */ GcFreeLoggingTestUtil[] $VALUES;

    public static GcFreeLoggingTestUtil[] values() {
        return (GcFreeLoggingTestUtil[])$VALUES.clone();
    }

    public static GcFreeLoggingTestUtil valueOf(String name) {
        return Enum.valueOf(GcFreeLoggingTestUtil.class, name);
    }

    public static void executeLogging(String configurationFile, Class<?> testClass) throws Exception {
        System.setProperty("log4j2.enableThreadlocals", "true");
        System.setProperty("log4j2.enableDirectEncoders", "true");
        System.setProperty("log4j2.configurationFile", configurationFile);
        System.setProperty("log4j2.clock", "SystemMillisClock");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Constants.ENABLE_THREADLOCALS, (String)"Constants.ENABLE_THREADLOCALS");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Constants.ENABLE_DIRECT_ENCODERS, (String)"Constants.ENABLE_DIRECT_ENCODERS");
        MyCharSeq myCharSeq = new MyCharSeq();
        Marker testGrandParent = MarkerManager.getMarker((String)"testGrandParent");
        Marker testParent = MarkerManager.getMarker((String)"testParent").setParents(new Marker[]{testGrandParent});
        Marker test = MarkerManager.getMarker((String)"test").setParents(new Marker[]{testParent});
        StringMapMessage mapMessage = (StringMapMessage)new StringMapMessage().with("eventId", "Login");
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        Logger logger = LogManager.getLogger((String)testClass.getName());
        logger.debug("debug not set");
        logger.fatal(test, "This message is logged to the console");
        logger.error("Sample error message");
        logger.error("Test parameterized message {}", (Object)"param");
        logger.error((Message)new StringMapMessage().with("eventId", "Login"));
        GcFreeLoggingTestUtil.singleLoggingIteration(logger, myCharSeq, mapMessage);
        for (int i = 0; i < 256; ++i) {
            logger.debug("ensure all ringbuffer slots have been used once");
        }
        ThreadContext.remove((String)"aKey");
        ThreadContext.remove((String)"key2");
        String[] exclude = new String[]{"java/util/concurrent/locks/AbstractQueuedSynchronizer$Node", "com/google/monitoring/runtime/instrumentation/Sampler"};
        AtomicBoolean samplingEnabled = new AtomicBoolean(true);
        Sampler sampler = (count, desc, newObj, size) -> {
            if (!samplingEnabled.get()) {
                return;
            }
            for (int i = 0; i < exclude.length; ++i) {
                if (!exclude[i].equals(desc)) continue;
                return;
            }
            System.err.println("I just allocated the object " + newObj + " of type " + desc + " whose size is " + size);
            if (count != -1) {
                System.err.println("It's an array of size " + count);
            }
            new RuntimeException().printStackTrace();
        };
        Thread.sleep(500L);
        AllocationRecorder.addSampler((Sampler)sampler);
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        int ITERATIONS = 5;
        for (int i = 0; i < 5; ++i) {
            GcFreeLoggingTestUtil.singleLoggingIteration(logger, myCharSeq, mapMessage);
            ThreadContext.remove((String)"aKey");
            ThreadContext.put((String)"aKey", (String)"value1");
        }
        Thread.sleep(50L);
        samplingEnabled.set(false);
        AllocationRecorder.removeSampler((Sampler)sampler);
        Thread.sleep(100L);
    }

    private static void singleLoggingIteration(Logger logger, MyCharSeq myCharSeq, StringMapMessage mapMessage) {
        logger.isEnabled(Level.TRACE);
        logger.isEnabled(Level.TRACE, MarkerManager.getMarker((String)"test"));
        logger.isTraceEnabled();
        logger.isTraceEnabled(MarkerManager.getMarker((String)"test"));
        logger.trace((CharSequence)myCharSeq);
        logger.trace(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.trace("Test message");
        logger.trace("Test parameterized message {}", (Object)"param");
        logger.trace("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.trace("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.trace(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.trace((Message)mapMessage);
        logger.isEnabled(Level.DEBUG);
        logger.isEnabled(Level.DEBUG, MarkerManager.getMarker((String)"test"));
        logger.isDebugEnabled();
        logger.isDebugEnabled(MarkerManager.getMarker((String)"test"));
        logger.debug((CharSequence)myCharSeq);
        logger.debug(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.debug("Test message");
        logger.debug("Test parameterized message {}", (Object)"param");
        logger.debug("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.debug("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.debug(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.debug((Message)mapMessage);
        logger.isEnabled(Level.INFO);
        logger.isEnabled(Level.INFO, MarkerManager.getMarker((String)"test"));
        logger.isInfoEnabled();
        logger.isInfoEnabled(MarkerManager.getMarker((String)"test"));
        logger.info((CharSequence)myCharSeq);
        logger.info(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.info("Test message");
        logger.info("Test parameterized message {}", (Object)"param");
        logger.info("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.info("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.info(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.info((Message)mapMessage);
        logger.isEnabled(Level.WARN);
        logger.isEnabled(Level.WARN, MarkerManager.getMarker((String)"test"));
        logger.isWarnEnabled();
        logger.isWarnEnabled(MarkerManager.getMarker((String)"test"));
        logger.warn((CharSequence)myCharSeq);
        logger.warn(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.warn("Test message");
        logger.warn("Test parameterized message {}", (Object)"param");
        logger.warn("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.warn("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.warn(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.warn((Message)mapMessage);
        logger.isEnabled(Level.ERROR);
        logger.isEnabled(Level.ERROR, MarkerManager.getMarker((String)"test"));
        logger.isErrorEnabled();
        logger.isErrorEnabled(MarkerManager.getMarker((String)"test"));
        logger.error((CharSequence)myCharSeq);
        logger.error(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.error("Test message");
        logger.error("Test parameterized message {}", (Object)"param");
        logger.error("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.error("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.error(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.error((Message)mapMessage);
        logger.isEnabled(Level.FATAL);
        logger.isEnabled(Level.FATAL, MarkerManager.getMarker((String)"test"));
        logger.isFatalEnabled();
        logger.isFatalEnabled(MarkerManager.getMarker((String)"test"));
        logger.fatal((CharSequence)myCharSeq);
        logger.fatal(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
        logger.fatal("Test message");
        logger.fatal("Test parameterized message {}", (Object)"param");
        logger.fatal("Test parameterized message {}{}", (Object)"param", (Object)"param2");
        logger.fatal("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.fatal(MarkerManager.getMarker((String)"test"), "Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
        logger.fatal((Message)mapMessage);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"})
    public static void runTest(Class<?> cls) throws Exception {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String javaagent = "-javaagent:" + GcFreeLoggingTestUtil.agentJar();
        File tempFile = File.createTempFile("allocations", ".txt");
        tempFile.deleteOnExit();
        ProcessBuilder builder = new ProcessBuilder(javaBin, javaagent, "-cp", classpath, cls.getName());
        builder.redirectError(ProcessBuilder.Redirect.to(tempFile));
        builder.redirectOutput(ProcessBuilder.Redirect.to(tempFile));
        Process process = builder.start();
        process.waitFor();
        process.exitValue();
        AtomicInteger lineCounter = new AtomicInteger(0);
        try (Stream<String> lines = Files.lines(tempFile.toPath(), Charset.defaultCharset());){
            Pattern pattern = Pattern.compile(String.format("^FATAL .*\\.%s [main].*", Pattern.quote(cls.getSimpleName())));
            Assertions.assertThat(lines.flatMap(l -> {
                int lineNumber = lineCounter.incrementAndGet();
                String line = l.trim();
                return pattern.matcher(line).matches() ? Stream.of(lineNumber + ": " + line) : Stream.empty();
            })).isEmpty();
        }
    }

    private static File agentJar() {
        String name = AllocationRecorder.class.getName();
        URL url = AllocationRecorder.class.getResource("/" + name.replace('.', '/').concat(".class"));
        if (url == null) {
            throw new IllegalStateException("Could not find url for " + name);
        }
        String temp = url.toString();
        String path = temp.substring("jar:file:".length(), temp.indexOf(33));
        return new File(path);
    }

    private static /* synthetic */ GcFreeLoggingTestUtil[] $values() {
        return new GcFreeLoggingTestUtil[0];
    }

    static {
        $VALUES = GcFreeLoggingTestUtil.$values();
    }

    public static class MyCharSeq
    implements CharSequence {
        final String seq = GcFreeLoggingTestUtil.class.toString();

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.seq.subSequence(start, end);
        }

        @Override
        public String toString() {
            System.err.println("TEMP OBJECT CREATED!");
            throw new IllegalStateException("TEMP OBJECT CREATED!");
        }
    }
}

