/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.FilteredObjectInputStream;

public class SerialUtil {
    private SerialUtil() {
    }

    public static byte[] serialize(Serializable obj) {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            oos.writeObject(obj);
            oos.flush();
            return bas.toByteArray();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not serialize", ex);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    public static <T> T deserialize(byte[] data) {
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(data);
            Object ois = Constants.JAVA_MAJOR_VERSION == 8 ? new FilteredObjectInputStream((InputStream)bas) : new ObjectInputStream(bas);
            return (T)((ObjectInputStream)ois).readObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not deserialize", ex);
        }
    }
}

