/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Properties;
import org.apache.logging.log4j.core.util.OptionConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionConverterTest {
    @Test
    public void testSubstVars() {
        Properties props = new Properties();
        props.setProperty("key", "${key}");
        props.setProperty("testKey", "Log4j");
        Assertions.assertEquals((Object)"Value of key is ${key}.", (Object)OptionConverter.substVars((String)"Value of key is ${key}.", (Properties)props));
        Assertions.assertEquals((Object)"Value of key is .", (Object)OptionConverter.substVars((String)"Value of key is ${key2}.", (Properties)props));
        Assertions.assertEquals((Object)"Value of testKey:testKey is Log4j:Log4j", (Object)OptionConverter.substVars((String)"Value of testKey:testKey is ${testKey}:${testKey}", (Properties)props));
    }

    @Test
    public void testAppend() {
        Properties props = new Properties();
        props.setProperty("key", "Key");
        props.setProperty("testKey", "Hello");
        Assertions.assertEquals((Object)"Value of testKey is }", (Object)OptionConverter.substVars((String)"Value of testKey is ${test${key}}", (Properties)props));
    }

    @Test
    public void testAppend2() {
        Properties props = new Properties();
        props.setProperty("test${key", "Hello");
        Assertions.assertEquals((Object)"Value of testKey is Hello}", (Object)OptionConverter.substVars((String)"Value of testKey is ${test${key}}", (Properties)props));
    }

    @Test
    public void testRecursion() {
        RecursiveProperties props = new RecursiveProperties();
        props.setProperty("name", "Neo");
        props.setProperty("greeting", "Hello ${name}");
        String s = ((Properties)props).getProperty("greeting");
        System.out.println("greeting = '" + s + "'");
    }

    private static class RecursiveProperties
    extends Properties {
        private RecursiveProperties() {
        }

        @Override
        public String getProperty(String key) {
            System.out.println("getProperty for " + key);
            try {
                String val = super.getProperty(key);
                return OptionConverter.substVars((String)val, (Properties)this);
            }
            catch (Exception e) {
                return super.getProperty(key);
            }
        }
    }
}

