/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.LoaderUtil;

public class TestClassLoader
extends ClassLoader {
    public TestClassLoader() {
        super(LoaderUtil.getThreadContextClassLoader());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith(this.getClass().getPackage().getName())) {
            return this.findClass(name);
        }
        return super.loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        URL resource = super.getResource(path);
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            URLConnection urlConnection = resource.openConnection();
            urlConnection.setUseCaches(false);
            int len = urlConnection.getContentLength();
            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
            byte[] bytecode = new byte[len];
            try {
                IOUtils.readFully((InputStream)in, (byte[])bytecode);
            }
            finally {
                Closer.closeSilently((AutoCloseable)in);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }
        catch (IOException e) {
            Throwables.rethrow((Throwable)e);
            return null;
        }
    }
}

