/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrowablePatternConverterTest {
    private boolean everyLineEndsWith(String text, String suffix) {
        String[] lines;
        for (String line : lines = text.split(Strings.LINE_SEPARATOR)) {
            if (line.trim().endsWith(suffix)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testBadShortOption() {
        String[] options = new String[]{"short.UNKNOWN"};
        Assertions.assertThrows(NumberFormatException.class, () -> ThrowablePatternConverter.newInstance(null, (String[])options));
    }

    @Test
    public void testFull() {
        String[] options = new String[]{"full"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        try {
            try {
                throw new NullPointerException("null pointer");
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("IllegalArgument", e);
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException parent = e;
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
            StringBuilder sb = new StringBuilder();
            converter.format((LogEvent)event, sb);
            String result = sb.toString();
            Assertions.assertTrue((boolean)result.startsWith("java.lang.IllegalArgumentException: IllegalArgument"), (String)"Incorrect start of msg");
            Assertions.assertTrue((boolean)result.contains("java.lang.NullPointerException: null pointer"), (String)"Missing nested exception");
            return;
        }
    }

    @Test
    public void testShortClassName() {
        String packageName = "org.apache.logging.log4j.core.pattern.";
        String[] options = new String[]{"short.className"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((Object)"org.apache.logging.log4j.core.pattern.ThrowablePatternConverterTest", (Object)result, (String)"The class names should be same");
    }

    @Test
    public void testShortFileName() {
        String[] options = new String[]{"short.fileName"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((Object)"ThrowablePatternConverterTest.java", (Object)result, (String)"The file names should be same");
    }

    @Test
    public void testShortLineNumber() {
        String[] options = new String[]{"short.lineNumber"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        StackTraceElement top = parent.getStackTrace()[0];
        int expectedLineNumber = top.getLineNumber();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((int)Integers.parseInt((String)result), (int)expectedLineNumber, (String)"The line numbers should be same");
    }

    @Test
    public void testShortLocalizedMessage() {
        String[] options = new String[]{"short.localizedMessage"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        LocalizedException parent = new LocalizedException();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((Object)"I am localized.", (Object)result, (String)"The messages should be same");
    }

    @Test
    public void testShortMessage() {
        String[] options = new String[]{"short.message"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((Object)"IllegalArgument", (Object)result, (String)"The messages should be same");
    }

    @Test
    public void testShortMethodName() {
        String[] options = new String[]{"short.methodName"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertEquals((Object)"testShortMethodName", (Object)result, (String)"The method names should be same");
    }

    @Test
    public void testFullWithSuffix() {
        String[] options = new String[]{"full", "suffix(test suffix)"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        try {
            try {
                throw new NullPointerException("null pointer");
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("IllegalArgument", e);
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException parent = e;
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
            StringBuilder sb = new StringBuilder();
            converter.format((LogEvent)event, sb);
            String result = sb.toString();
            Assertions.assertTrue((boolean)this.everyLineEndsWith(result, "test suffix"), (String)"Each line of full stack trace should end with the specified suffix");
            return;
        }
    }

    @Test
    public void testShortOptionWithSuffix() {
        String packageName = "org.apache.logging.log4j.core.pattern.";
        String[] options = new String[]{"short.className", "suffix(test suffix)"};
        ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertTrue((boolean)this.everyLineEndsWith(result, "test suffix"), (String)"Each line should end with suffix");
    }

    private static final class LocalizedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private LocalizedException() {
        }

        @Override
        public String getLocalizedMessage() {
            return "I am localized.";
        }
    }
}

