/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.HighlightConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HighlightConverterTest {
    @Test
    public void testAnsiEmpty() {
        String[] options = new String[]{"", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assertions.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assertions.assertEquals((Object)"\u001b[32mINFO : message in a bottle\u001b[m", (Object)buffer.toString());
    }

    @Test
    public void testLevelNamesBad() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, BAD_LEVEL_A=red, BAD_LEVEL_B=red"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testLevelNamesGood() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, DEBUG=red, TRACE=red"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Assertions.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{"red"}), (Object)converter.getLevelStyle(Level.TRACE));
        Assertions.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{"red"}), (Object)converter.getLevelStyle(Level.DEBUG));
    }

    static Stream<Arguments> colors() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bright red", "\u001b[1;31m"}), Arguments.of((Object[])new Object[]{"red bright", "\u001b[31;1m"}), Arguments.of((Object[])new Object[]{"bright_red", "\u001b[91m"}), Arguments.of((Object[])new Object[]{"#1cd42b", "\u001b[38;2;28;212;43m"}), Arguments.of((Object[])new Object[]{"fg_bright_red bg_bright_blue bold", "\u001b[91;104;1m"}), Arguments.of((Object[])new Object[]{"FG_#1cd42b BG_#000000", "\u001b[38;2;28;212;43;48;2;0;0;0m"}));
    }

    @ParameterizedTest
    @MethodSource(value={"colors"})
    public void testColors(String colorName, String escape) {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, INFO=" + colorName};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assertions.assertEquals((Object)(escape + "INFO : \u001b[m"), (Object)buffer.toString());
    }

    @Test
    public void testLevelNamesUnknown() {
        String colorName = "blue";
        String[] options = new String[]{"%level", "noConsoleNoAnsi=false, disableAnsi=false, DEBUG=blue, CUSTOM1=blue"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.INFO));
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.forName((String)"CUSTOM1", (int)412)));
        Assertions.assertNull((Object)converter.getLevelStyle(Level.forName((String)"CUSTOM2", (int)512)));
        Assertions.assertArrayEquals((byte[])new byte[]{27, 91, 51, 52, 109, 68, 69, 66, 85, 71, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.DEBUG).toString().getBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{27, 91, 51, 50, 109, 73, 78, 70, 79, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.INFO).toString().getBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{27, 91, 51, 52, 109, 67, 85, 83, 84, 79, 77, 49, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.forName((String)"CUSTOM1", (int)412)).toString().getBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{67, 85, 83, 84, 79, 77, 50}, (byte[])this.toFormattedCharSeq(converter, Level.forName((String)"CUSTOM2", (int)512)).toString().getBytes());
    }

    @Test
    public void testLevelNamesNone() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assertions.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testNoAnsiEmpty() {
        String[] options = new String[]{"", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assertions.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testNoAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assertions.assertNotNull((Object)converter);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assertions.assertEquals((Object)"INFO : message in a bottle", (Object)buffer.toString());
    }

    private CharSequence toFormattedCharSeq(HighlightConverter converter, Level level) {
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)Log4jLogEvent.newBuilder().setLevel(level).build(), sb);
        return sb;
    }
}

