/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.TlsSyslogInputStreamReaderBase;
import org.apache.logging.log4j.core.net.ssl.TlsSyslogMessageFormat;
import org.apache.logging.log4j.core.util.Integers;

public class TlsSyslogInputStreamReader
extends TlsSyslogInputStreamReaderBase {
    private static final char SPACE = ' ';
    private final ByteArrayOutputStream messageBuffer = new ByteArrayOutputStream(8192);
    private final byte[] messagePartBuffer;
    private final byte[] lengthBuffer = new byte[8192];
    private final int messagePartBufferSize = 8192;
    private final int lengthBufferSize = 8192;
    private int position = 0;
    private int nextMessageLength = 0;

    public TlsSyslogInputStreamReader(InputStream inputStream) {
        super(inputStream, TlsSyslogMessageFormat.SYSLOG);
        this.messagePartBuffer = new byte[8192];
    }

    @Override
    public String read() throws IOException {
        this.readMessageLength();
        this.readMessage();
        String message = this.buildMessage();
        return message;
    }

    private void readMessageLength() throws IOException {
        this.readBytesUntilNextSpace();
        this.calculateNextMessageLength();
    }

    private void readMessage() throws IOException {
        int n;
        for (int remainder = this.nextMessageLength; remainder > 0; remainder -= n) {
            int bytesToRead = Math.min(remainder, 8192);
            n = this.inputStream.read(this.messagePartBuffer, 0, bytesToRead);
            this.messageBuffer.write(this.messagePartBuffer, 0, n);
        }
    }

    private String buildMessage() {
        String message = this.messageBuffer.toString();
        this.messageBuffer.reset();
        return message;
    }

    private void readBytesUntilNextSpace() throws IOException {
        for (int i = 0; i < 8192; ++i) {
            int b = this.inputStream.read();
            if (b < 0) {
                throw new EOFException("The stream has been closed or the end of stream has been reached");
            }
            byte currentByte = (byte)(b & 0xFF);
            if (currentByte == 32) {
                this.position = i;
                break;
            }
            this.lengthBuffer[i] = currentByte;
        }
    }

    private void calculateNextMessageLength() {
        byte[] length = Arrays.copyOfRange(this.lengthBuffer, 0, this.position);
        this.nextMessageLength = Integers.parseInt((String)new String(length));
    }
}

