/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Properties;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfigurationTest;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SslConfigurationFactoryTest {
    private static final String trustStorelocation = "log4j2.trustStoreLocation";
    private static final String trustStorePassword = "log4j2.trustStorePassword";
    private static final String trustStoreKeyStoreType = "log4j2.trustStoreKeyStoreType";
    private static final String keyStoreLocation = "log4j2.keyStoreLocation";
    private static final String keyStorePassword = "log4j2.keyStorePassword";
    private static final String keyStoreType = "log4j2.keyStoreType";

    private static void addKeystoreConfiguration(Properties props) {
        props.setProperty(keyStoreLocation, "org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks");
        props.setProperty(keyStoreType, "JKS");
    }

    private static void addTruststoreConfiguration(Properties props) {
        props.setProperty(trustStorelocation, "org/apache/logging/log4j/core/net/ssl/truststore.jks");
        props.setProperty(trustStoreKeyStoreType, "JKS");
    }

    @Test
    public void testStaticConfiguration() {
        Properties props = new Properties();
        PropertiesUtil util = new PropertiesUtil(props);
        SslConfiguration sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNull((Object)sslConfiguration);
        props.clear();
        SslConfigurationFactoryTest.addKeystoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNotNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNull((Object)sslConfiguration.getTrustStoreConfig());
        props.clear();
        SslConfigurationFactoryTest.addTruststoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNotNull((Object)sslConfiguration.getTrustStoreConfig());
        props.clear();
        SslConfigurationFactoryTest.addKeystoreConfiguration(props);
        SslConfigurationFactoryTest.addTruststoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNotNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNotNull((Object)sslConfiguration.getTrustStoreConfig());
    }

    static Stream<Arguments> windowsKeystoreConfigs() {
        String[] emptyOrNull = new String[]{"", null};
        Stream.Builder<Arguments> builder = Stream.builder();
        for (String location : emptyOrNull) {
            for (String password : emptyOrNull) {
                builder.add(Arguments.of((Object[])new Object[]{location, password}));
            }
        }
        return builder.build();
    }

    @EnabledOnOs(value={OS.WINDOWS})
    @ParameterizedTest
    @MethodSource(value={"windowsKeystoreConfigs"})
    public void testPasswordLessStores(String location, String password) {
        Properties props = new Properties();
        props.setProperty(keyStoreType, "Windows-MY");
        props.setProperty(trustStoreKeyStoreType, "Windows-ROOT");
        if (location != null) {
            props.setProperty(keyStoreLocation, location);
            props.setProperty(trustStorelocation, location);
        }
        if (password != null) {
            props.setProperty(keyStorePassword, password);
            props.setProperty(trustStorePassword, password);
        }
        PropertiesUtil util = new PropertiesUtil(props);
        SslConfiguration config = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)config);
        KeyStoreConfiguration keyStoreConfig = config.getKeyStoreConfig();
        Assertions.assertNotNull((Object)keyStoreConfig);
        KeyStoreConfigurationTest.checkKeystoreConfiguration((AbstractKeyStoreConfiguration)keyStoreConfig);
        TrustStoreConfiguration trustStoreConfig = config.getTrustStoreConfig();
        Assertions.assertNotNull((Object)trustStoreConfig);
        KeyStoreConfigurationTest.checkKeystoreConfiguration((AbstractKeyStoreConfiguration)trustStoreConfig);
    }
}

