/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MemoryPasswordProviderTest {
    @Test
    public void testConstructorAllowsNull() {
        Assertions.assertNull((Object)new MemoryPasswordProvider(null).getPassword());
    }

    @Test
    public void testConstructorDoesNotModifyOriginalParameterArray() {
        char[] initial = "123".toCharArray();
        new MemoryPasswordProvider(initial);
        Assertions.assertArrayEquals((char[])"123".toCharArray(), (char[])initial);
    }

    @Test
    public void testGetPasswordReturnsCopyOfConstructorArray() {
        char[] initial = "123".toCharArray();
        MemoryPasswordProvider provider = new MemoryPasswordProvider(initial);
        char[] actual = provider.getPassword();
        Assertions.assertArrayEquals((char[])"123".toCharArray(), (char[])actual);
        Assertions.assertNotSame((Object)initial, (Object)actual);
        Arrays.fill(initial, 'a');
        Assertions.assertArrayEquals((char[])"123".toCharArray(), (char[])provider.getPassword());
        Assertions.assertNotSame((Object)provider.getPassword(), (Object)provider.getPassword());
    }
}

