/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStore;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key="sun.security.mscapi.keyStoreCompatibilityMode", value="false")
public class KeyStoreConfigurationTest {
    @Test
    public void loadEmptyConfigurationDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration(null, TestConstants.NULL_PWD, null, null));
    }

    @Test
    public void loadEmptyConfiguration() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration(null, (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null));
    }

    @Test
    public void loadNotEmptyConfigurationDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
        KeyStoreConfigurationTest.checkKeystoreConfiguration((AbstractKeyStoreConfiguration)ksc);
    }

    static Stream<Arguments> configurations() {
        Stream.Builder<Arguments> builder = Stream.builder();
        builder.add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants::KEYSTORE_PWD, "JKS"})).add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.p12", TestConstants::KEYSTORE_PKCS12_PWD, "PKCS12"})).add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore-nopass.p12", TestConstants::KEYSTORE_EMPTYPASS_PWD, "PKCS12"}));
        if (OS.WINDOWS.isCurrentOs()) {
            builder.add(Arguments.of((Object[])new Object[]{null, () -> null, "Windows-MY"})).add(Arguments.of((Object[])new Object[]{null, () -> null, "Windows-ROOT"}));
        }
        return builder.build();
    }

    @ParameterizedTest
    @MethodSource(value={"configurations"})
    public void loadNotEmptyConfiguration(String keystoreFile, Supplier<char[]> password, String keystoreType) throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration(keystoreFile, (PasswordProvider)new MemoryPasswordProvider(password.get()), keystoreType, null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
        KeyStoreConfigurationTest.checkKeystoreConfiguration((AbstractKeyStoreConfiguration)ksc);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoadsDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoads() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void wrongPasswordDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", "wrongPassword!", null, null));
    }

    static Stream<Arguments> wrongConfigurations() {
        Stream.Builder<Arguments> builder = Stream.builder();
        builder.add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants::KEYSTORE_EMPTYPASS_PWD, "JKS"})).add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", () -> "wrongPassword!".toCharArray(), "JKS"})).add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.p12", TestConstants::KEYSTORE_EMPTYPASS_PWD, "PKCS12"})).add(Arguments.of((Object[])new Object[]{"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.p12", TestConstants::KEYSTORE_EMPTYPASS_PWD, "PKCS12"}));
        if (OS.WINDOWS.isCurrentOs()) {
            builder.add(Arguments.of((Object[])new Object[]{null, () -> new char[0], "Windows-MY"})).add(Arguments.of((Object[])new Object[]{null, () -> new char[0], "Windows-ROOT"}));
        }
        return builder.build();
    }

    @ParameterizedTest
    @MethodSource(value={"wrongConfigurations"})
    public void wrongPassword(String keystoreFile, Supplier<char[]> password, String keystoreType) {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration(keystoreFile, (PasswordProvider)new MemoryPasswordProvider((char[])password.get()), keystoreType, null));
    }

    static void checkKeystoreConfiguration(AbstractKeyStoreConfiguration config) {
        Assertions.assertDoesNotThrow(() -> {
            KeyStore ks = config.load();
            for (String alias : Collections.list(ks.aliases())) {
                if (ks.isCertificateEntry(alias)) {
                    ks.getCertificate(alias);
                }
                if (!ks.isKeyEntry(alias)) continue;
                ks.getKey(alias, config.getPasswordAsCharArray());
            }
        });
    }
}

