/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StrSubstitutorTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTVAL = "TestValue";

    @AfterAll
    public static void after() {
        System.clearProperty(TESTKEY);
    }

    @BeforeAll
    public static void before() {
        System.setProperty(TESTKEY, TESTVAL);
    }

    @Test
    public void testJavaDocExample() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("animal", "quick brown fox");
        valuesMap.put("target", "lazy dog");
        String templateString = "The ${animal} jumped over the ${target}.";
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        String resolvedString = sub.replace("The ${animal} jumped over the ${target}.");
        Assertions.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)resolvedString);
    }

    @Test
    public void testDelimiterExampleFromJavaDoc() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("animal", "quick brown fox");
        valuesMap.put("target", "lazy dog");
        String templateString = "The ${animal} jumped over the ${target}. ${undefined.number:-1234567890}";
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        String resolvedString = sub.replace("The ${animal} jumped over the ${target}. ${undefined.number:-1234567890}");
        Assertions.assertEquals((Object)"The quick brown fox jumped over the lazy dog. 1234567890", (Object)resolvedString);
    }

    @Test
    public void testEscapedRecursionExampleFromJavaDoc() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("name", "x");
        String templateString = "The variable $${${name}} must be used.";
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        sub.setEnableSubstitutionInVariables(false);
        String resolvedString = sub.replace("The variable $${${name}} must be used.");
        Assertions.assertEquals((Object)"The variable ${x} must be used.", (Object)resolvedString);
        sub.setEnableSubstitutionInVariables(true);
        String resolvedStringWithRecursion = sub.replace("The variable $${${name}} must be used.");
        Assertions.assertEquals((Object)resolvedString, (Object)resolvedStringWithRecursion);
    }

    @Test
    public void testPrePostfixRecursionExampleFromJavaDoc() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("name", "x");
        String templateString = "The variable ${$[name]} must be used.";
        StrSubstitutor sub = new StrSubstitutor(valuesMap, "$[", "]");
        String resolvedString = sub.replace("The variable ${$[name]} must be used.");
        Assertions.assertEquals((Object)"The variable ${x} must be used.", (Object)resolvedString);
    }

    @Test
    public void testRecursionExampleFromJavaDoc() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("name", "x");
        valuesMap.put("x", "3");
        String templateString = "The value ${${name}} must be used.";
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        sub.setEnableSubstitutionInVariables(false);
        Assertions.assertEquals((Object)"The value ${${name}} must be used.", (Object)sub.replace("The value ${${name}} must be used."));
        sub.setEnableSubstitutionInVariables(true);
        Assertions.assertEquals((Object)"The value 3 must be used.", (Object)sub.replace("The value ${${name}} must be used."));
    }

    @Test
    public void testValueEscapeDelimiter() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("main:--file", "path/file.txt");
        StrSubstitutor sub = new StrSubstitutor((StrLookup)new RecursiveLookup(valuesMap), StrSubstitutor.DEFAULT_PREFIX, StrSubstitutor.DEFAULT_SUFFIX, '$', StrSubstitutor.DEFAULT_VALUE_DELIMITER, null);
        Assertions.assertEquals((Object)"3", (Object)sub.replace("${y:-3}"));
        Assertions.assertEquals((Object)"-file", (Object)sub.replace("${main:--file}"));
        Assertions.assertEquals((Object)"${main:\\--file}", (Object)sub.replace("${main:\\--file}"));
        sub.setValueDelimiter(":-");
        Assertions.assertEquals((Object)"path/file.txt", (Object)sub.replace("${main:\\--file}"));
        Assertions.assertEquals((Object)"no help", (Object)sub.replace("${main:\\--help:-no help}"));
        Assertions.assertEquals((Object)"", (Object)sub.replace("${:\\-:-}"));
    }

    @Test
    public void testDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${sys:TestKey1:-${ctx:TestKey}}");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
    }

    @Test
    public void testDefaultReferencesLookupValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, "${java:version}");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        String value = subst.replace("${sys:TestKey1:-${ctx:TestKey}}");
        Assertions.assertEquals((Object)"${java:version}", (Object)value);
    }

    @Test
    public void testInfiniteSubstitutionOnString() {
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(new HashMap<String, String>()));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        String infiniteSubstitution = "${${::-${::-$${::-j}}}}";
        Assertions.assertEquals((Object)"j}", (Object)subst.replace(infiniteSubstitution));
    }

    @Test
    public void testInfiniteSubstitutionOnStringBuilder() {
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(new HashMap<String, String>()));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        String infiniteSubstitution = "${${::-${::-$${::-j}}}}";
        Assertions.assertEquals((Object)"j}", (Object)subst.replace(null, new StringBuilder(infiniteSubstitution)));
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${TestKey}-${ctx:TestKey}-${sys:TestKey}");
        Assertions.assertEquals((Object)"TestValue-TestValue-TestValue", (Object)value);
        value = subst.replace("${BadKey}");
        Assertions.assertEquals((Object)"${BadKey}", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-Unknown}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown-Unknown-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown-${ctx:BadKey}-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown--Unknown", (Object)value);
    }

    @Test
    public void testLookupsNestedWithoutRecursiveEvaluation() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${java:version}");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${java:version}", (Object)subst.replace("${${lower:C}t${lower:X}:first}"));
    }

    @Test
    public void testLookupThrows() {
        StrSubstitutor subst = new StrSubstitutor((StrLookup)new Interpolator(new StrLookup(){

            public String lookup(LogEvent event, String key) {
                return this.lookup(key);
            }

            public String lookup(String key) {
                if ("throw".equals(key)) {
                    throw new RuntimeException();
                }
                return "success";
            }
        }));
        Assertions.assertEquals((Object)"success ${foo:throw} success", (Object)subst.replace("${foo:a} ${foo:throw} ${foo:c}"));
    }

    @Test
    public void testNestedSelfReferenceWithRecursiveEvaluation() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new RecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${${ctx:first}}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testNoRecursiveEvaluationWithDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${java:version}");
        map.put("second", "${java:runtime}");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${java:version}", (Object)subst.replace("${ctx:first:-${ctx:second}}"));
    }

    @Test
    public void testNoRecursiveEvaluationWithDepthOne() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${java:version}");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${java:version}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testRandomWithRecursiveDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${env:RANDOM:-${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new RecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${ctx:first}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testRecursiveSubstitution() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first}");
        map.put("second", "secondValue");
        Interpolator lookup = new Interpolator((StrLookup)new RecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${ctx:first} and secondValue", (Object)subst.replace("${ctx:first} and ${ctx:second}"));
    }

    @Test
    public void testRecursiveWithDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first:-default}");
        Interpolator lookup = new Interpolator((StrLookup)new RecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"default", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testRecursiveWithRecursiveDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first:-${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new RecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"${ctx:first}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testReplaceProperties() {
        Properties properties = new Properties();
        properties.put("a", "A");
        Assertions.assertNull((Object)StrSubstitutor.replace((Object)null, (Properties)properties));
        Assertions.assertNull((Object)StrSubstitutor.replace((Object)null, (Properties)null));
        Assertions.assertEquals((Object)"A", (Object)StrSubstitutor.replace((Object)"${a}", (Properties)properties));
        Assertions.assertEquals((Object)"${a}", (Object)StrSubstitutor.replace((Object)"${a}", (Properties)null));
    }

    @Test
    public void testTopLevelLookupsWithoutRecursiveEvaluation() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "VaLuE");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"value", (Object)subst.replace("${lower:${ctx:key}}"));
    }

    @Test
    public void testTopLevelLookupsWithoutRecursiveEvaluation_doubleLower() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "VaLuE");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"value", (Object)subst.replace("${lower:${lower:${ctx:key}}}"));
    }

    @Test
    public void testTopLevelLookupsWithoutRecursiveEvaluationAndDefaultValueLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key2", "TWO");
        Interpolator lookup = new Interpolator((StrLookup)new NonRecursiveLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        Assertions.assertEquals((Object)"two", (Object)subst.replace("${lower:${ctx:key1:-${ctx:key2}}}"));
    }

    @Test
    public void testNonRecursiveReferencesRecursive() {
        StrLookup lookup = new StrLookup(){

            public String lookup(String key) {
                return "unexpected";
            }

            public String lookup(LogEvent event, String key) {
                return "unexpected";
            }

            public LookupResult evaluate(String key) {
                return this.evaluate(null, key);
            }

            public LookupResult evaluate(LogEvent event, String key) {
                switch (key) {
                    case "first": {
                        return new RecursiveLookupResult("${second}");
                    }
                    case "second": {
                        return new NonRecursiveLookupResult("${third}");
                    }
                }
                return new RecursiveLookupResult("should not be used: " + key);
            }
        };
        StrSubstitutor subst = new StrSubstitutor(lookup);
        Assertions.assertEquals((Object)"${third}", (Object)subst.replace("${first}"));
    }

    private static final class NonRecursiveLookupResult
    implements LookupResult {
        private final String value;

        NonRecursiveLookupResult(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean isLookupEvaluationAllowedInValue() {
            return false;
        }
    }

    private static final class NonRecursiveLookup
    extends AbstractLookup {
        private final Map<String, String> properties;

        NonRecursiveLookup(Map<String, String> properties) {
            this.properties = properties;
        }

        public String lookup(LogEvent event, String key) {
            LookupResult result = this.evaluate(event, key);
            return result == null ? null : result.value();
        }

        public LookupResult evaluate(LogEvent event, String key) {
            String result = key == null ? null : this.properties.get(key);
            return result == null ? null : new NonRecursiveLookupResult(result);
        }
    }

    private static final class RecursiveLookupResult
    implements LookupResult {
        private final String value;

        RecursiveLookupResult(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean isLookupEvaluationAllowedInValue() {
            return true;
        }
    }

    private static final class RecursiveLookup
    extends AbstractLookup {
        private final Map<String, String> properties;

        RecursiveLookup(Map<String, String> properties) {
            this.properties = properties;
        }

        public String lookup(LogEvent event, String key) {
            LookupResult result = this.evaluate(event, key);
            return result == null ? null : result.value();
        }

        public LookupResult evaluate(LogEvent event, String key) {
            String result = key == null ? null : this.properties.get(key);
            return result == null ? null : new RecursiveLookupResult(result);
        }
    }
}

