/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.convert.Base64Converter;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Log4jLogEventTest {
    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j.Clock", FixedTimeClock.class.getName());
    }

    @AfterAll
    public static void afterClass() throws IllegalAccessException {
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testToImmutableSame() {
        Log4jLogEvent logEvent = new Log4jLogEvent();
        Assertions.assertSame((Object)logEvent, (Object)logEvent.toImmutable());
    }

    @Test
    public void testToImmutableNotSame() {
        Log4jLogEvent logEvent = new Log4jLogEvent.Builder().setMessage((Message)new ReusableObjectMessage()).build();
        LogEvent immutable = logEvent.toImmutable();
        Assertions.assertSame((Object)logEvent, (Object)immutable);
        Assertions.assertFalse((boolean)(immutable.getMessage() instanceof ReusableMessage));
    }

    @Test
    public void testJavaIoSerializable() throws Exception {
        Log4jLogEvent evt = Log4jLogEvent.newBuilder().setLoggerName("some.test").setLoggerFqcn("").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("abc")).build();
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assertions.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assertions.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assertions.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assertions.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assertions.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assertions.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assertions.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assertions.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assertions.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assertions.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assertions.assertEquals((Object)evt.getThrown(), (Object)evt2.getThrown());
        Assertions.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assertions.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
    }

    @Test
    public void testJavaIoSerializableWithThrown() throws Exception {
        InternalError thrown = new InternalError("test error");
        Log4jLogEvent evt = Log4jLogEvent.newBuilder().setLoggerName("some.test").setLoggerFqcn("").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("abc")).setThrown((Throwable)thrown).build();
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assertions.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assertions.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assertions.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assertions.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assertions.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assertions.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assertions.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assertions.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assertions.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assertions.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assertions.assertNull((Object)evt2.getThrown());
        Assertions.assertNotNull((Object)evt2.getThrownProxy());
        Assertions.assertEquals((Object)evt.getThrownProxy(), (Object)evt2.getThrownProxy());
        Assertions.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assertions.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
    }

    private byte[] serialize(Log4jLogEvent event) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(event);
        return arr.toByteArray();
    }

    private Log4jLogEvent deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        FilteredObjectInputStream in = new FilteredObjectInputStream((InputStream)inArr);
        Log4jLogEvent result = (Log4jLogEvent)in.readObject();
        return result;
    }

    @Test
    public void testJavaIoSerializableWithUnknownThrowable() throws Exception {
        String loggerName = "some.test";
        Object marker = null;
        String loggerFQN = "";
        Level level = Level.INFO;
        SimpleMessage msg = new SimpleMessage("abc");
        String threadName = Thread.currentThread().getName();
        String errorMessage = "OMG I've been deleted!";
        String base64 = "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";
        byte[] binaryDecoded = Base64Converter.parseBase64Binary((String)"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");
        Log4jLogEvent evt2 = this.deserialize(binaryDecoded);
        Assertions.assertEquals((Object)"", (Object)evt2.getLoggerFqcn());
        Assertions.assertEquals((Object)level, (Object)evt2.getLevel());
        Assertions.assertEquals((Object)"some.test", (Object)evt2.getLoggerName());
        Assertions.assertEquals(marker, (Object)evt2.getMarker());
        Assertions.assertEquals((Object)msg, (Object)evt2.getMessage());
        Assertions.assertEquals((Object)threadName, (Object)evt2.getThreadName());
        Assertions.assertNull((Object)evt2.getThrown());
        Assertions.assertEquals((Object)(this.getClass().getName() + "$DeletedException"), (Object)evt2.getThrownProxy().getName());
        Assertions.assertEquals((Object)"OMG I've been deleted!", (Object)evt2.getThrownProxy().getMessage());
    }

    @Test
    public void testNullLevelReplacedWithOFF() throws Exception {
        Level NULL_LEVEL = null;
        Log4jLogEvent evt = Log4jLogEvent.newBuilder().setLevel(NULL_LEVEL).build();
        Assertions.assertEquals((Object)Level.OFF, (Object)evt.getLevel());
    }

    @Test
    public void testTimestampGeneratedByClock() {
        Log4jLogEvent evt = Log4jLogEvent.newBuilder().build();
        Assertions.assertEquals((long)1234567890L, (long)evt.getTimeMillis());
    }

    @Test
    public void testInitiallyDummyNanoClock() {
        Assertions.assertTrue((boolean)(Log4jLogEvent.getNanoClock() instanceof DummyNanoClock));
        Assertions.assertEquals((long)0L, (long)Log4jLogEvent.getNanoClock().nanoTime(), (String)"initial dummy nanotime");
    }

    @Test
    public void testNanoTimeGeneratedByNanoClock() {
        Log4jLogEvent.setNanoClock((NanoClock)new DummyNanoClock(123L));
        this.verifyNanoTimeWithAllConstructors(123L);
        Log4jLogEvent.setNanoClock((NanoClock)new DummyNanoClock(87654L));
        this.verifyNanoTimeWithAllConstructors(87654L);
    }

    private void verifyNanoTimeWithAllConstructors(long expected) {
        Assertions.assertEquals((long)expected, (long)Log4jLogEvent.getNanoClock().nanoTime());
        Assertions.assertEquals((long)expected, (long)new Log4jLogEvent().getNanoTime(), (String)"No-arg constructor");
        Assertions.assertEquals((long)expected, (long)new Log4jLogEvent(98L).getNanoTime(), (String)"1-arg constructor");
        Assertions.assertEquals((long)expected, (long)new Log4jLogEvent("l", null, "a", null, null, null).getNanoTime(), (String)"6-arg constructor");
        Assertions.assertEquals((long)expected, (long)new Log4jLogEvent("l", null, "a", null, null, null, null).getNanoTime(), (String)"7-arg constructor");
        Assertions.assertEquals((long)expected, (long)new Log4jLogEvent("l", null, "a", null, null, null, null, null, null, null, 0L).getNanoTime(), (String)"11-arg constructor");
        Assertions.assertEquals((long)expected, (long)Log4jLogEvent.createEvent((String)"l", null, (String)"a", null, null, null, null, null, null, null, null, (long)0L).getNanoTime(), (String)"12-arg factory method");
    }

    @Test
    public void testBuilderCorrectlyCopiesAllEventAttributes() {
        StringMap contextData = ContextDataFactory.createContextData();
        contextData.putValue("A", (Object)"B");
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        Exception exception = new Exception("test");
        Marker marker = MarkerManager.getMarker((String)"EVENTTEST");
        SimpleMessage message = new SimpleMessage("foo");
        StackTraceElement stackTraceElement = new StackTraceElement("A", "B", "file", 123);
        String fqcn = "qualified";
        String name = "Ceci n'est pas une pipe";
        String threadName = "threadName";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setContextData(contextData).setContextStack(contextStack).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("qualified").setLoggerName("Ceci n'est pas une pipe").setMarker(marker).setMessage((Message)message).setNanoTime(1234567890L).setSource(stackTraceElement).setThreadName("threadName").setThrown((Throwable)exception).setTimeMillis(987654321L).build();
        Assertions.assertEquals((Object)contextData, (Object)event.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)event.getContextStack());
        Assertions.assertTrue((boolean)event.isEndOfBatch());
        Assertions.assertTrue((boolean)event.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)event.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)event.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)event.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)event.getMarker());
        Assertions.assertSame((Object)message, (Object)event.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)event.getNanoTime());
        Assertions.assertSame((Object)stackTraceElement, (Object)event.getSource());
        Assertions.assertSame((Object)"threadName", (Object)event.getThreadName());
        Assertions.assertSame((Object)exception, (Object)event.getThrown());
        Assertions.assertEquals((long)987654321L, (long)event.getTimeMillis());
        Log4jLogEvent event2 = new Log4jLogEvent.Builder((LogEvent)event).build();
        Assertions.assertEquals((Object)event2, (Object)event, (String)"copy constructor builder");
        Assertions.assertEquals((int)event2.hashCode(), (int)event.hashCode(), (String)"same hashCode");
    }

    @Test
    public void testBuilderCorrectlyCopiesAllEventAttributesInclContextData() {
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        contextData.putValue("A", (Object)"B");
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        Exception exception = new Exception("test");
        Marker marker = MarkerManager.getMarker((String)"EVENTTEST");
        SimpleMessage message = new SimpleMessage("foo");
        StackTraceElement stackTraceElement = new StackTraceElement("A", "B", "file", 123);
        String fqcn = "qualified";
        String name = "Ceci n'est pas une pipe";
        String threadName = "threadName";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setContextData((StringMap)contextData).setContextStack(contextStack).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("qualified").setLoggerName("Ceci n'est pas une pipe").setMarker(marker).setMessage((Message)message).setNanoTime(1234567890L).setSource(stackTraceElement).setThreadName("threadName").setThrown((Throwable)exception).setTimeMillis(987654321L).build();
        Assertions.assertSame((Object)contextData, (Object)event.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)event.getContextStack());
        Assertions.assertTrue((boolean)event.isEndOfBatch());
        Assertions.assertTrue((boolean)event.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)event.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)event.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)event.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)event.getMarker());
        Assertions.assertSame((Object)message, (Object)event.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)event.getNanoTime());
        Assertions.assertSame((Object)stackTraceElement, (Object)event.getSource());
        Assertions.assertSame((Object)"threadName", (Object)event.getThreadName());
        Assertions.assertSame((Object)exception, (Object)event.getThrown());
        Assertions.assertEquals((long)987654321L, (long)event.getTimeMillis());
        Log4jLogEvent event2 = new Log4jLogEvent.Builder((LogEvent)event).build();
        Assertions.assertEquals((Object)event2, (Object)event, (String)"copy constructor builder");
        Assertions.assertEquals((int)event2.hashCode(), (int)event.hashCode(), (String)"same hashCode");
    }

    @Test
    public void testBuilderCorrectlyCopiesMutableLogEvent() throws Exception {
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        contextData.putValue("A", (Object)"B");
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        Exception exception = new Exception("test");
        Marker marker = MarkerManager.getMarker((String)"EVENTTEST");
        SimpleMessage message = new SimpleMessage("foo");
        new StackTraceElement("A", "B", "file", 123);
        String fqcn = "qualified";
        String name = "Ceci n'est pas une pipe";
        String threadName = "threadName";
        MutableLogEvent event = new MutableLogEvent();
        event.setContextData((StringMap)contextData);
        event.setContextStack(contextStack);
        event.setEndOfBatch(true);
        event.setIncludeLocation(true);
        event.setLevel(Level.FATAL);
        event.setLoggerFqcn("qualified");
        event.setLoggerName("Ceci n'est pas une pipe");
        event.setMarker(marker);
        event.setMessage((Message)message);
        event.setNanoTime(1234567890L);
        event.setThreadName("threadName");
        event.setThrown((Throwable)exception);
        event.setTimeMillis(987654321L);
        Assertions.assertSame((Object)contextData, (Object)event.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)event.getContextStack());
        Assertions.assertTrue((boolean)event.isEndOfBatch());
        Assertions.assertTrue((boolean)event.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)event.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)event.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)event.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)event.getMarker());
        Assertions.assertSame((Object)message, (Object)event.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)event.getNanoTime());
        Assertions.assertSame((Object)"threadName", (Object)event.getThreadName());
        Assertions.assertSame((Object)exception, (Object)event.getThrown());
        Assertions.assertEquals((long)987654321L, (long)event.getTimeMillis());
        Log4jLogEvent e2 = new Log4jLogEvent.Builder((LogEvent)event).build();
        Assertions.assertEquals((Object)contextData, (Object)e2.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)e2.getContextStack());
        Assertions.assertTrue((boolean)e2.isEndOfBatch());
        Assertions.assertTrue((boolean)e2.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)e2.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)e2.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)e2.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)e2.getMarker());
        Assertions.assertSame((Object)message, (Object)e2.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)e2.getNanoTime());
        Assertions.assertSame((Object)"threadName", (Object)e2.getThreadName());
        Assertions.assertSame((Object)exception, (Object)e2.getThrown());
        Assertions.assertEquals((long)987654321L, (long)e2.getTimeMillis());
        Field fieldSource = Log4jLogEvent.class.getDeclaredField("source");
        fieldSource.setAccessible(true);
        Object value = fieldSource.get(e2);
        Assertions.assertNull((Object)value, (String)"source in copy");
    }

    @Test
    public void testEquals() {
        StringMap contextData = ContextDataFactory.createContextData();
        contextData.putValue("A", (Object)"B");
        ThreadContext.push((String)"first");
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        Exception exception = new Exception("test");
        Marker marker = MarkerManager.getMarker((String)"EVENTTEST");
        SimpleMessage message = new SimpleMessage("foo");
        StackTraceElement stackTraceElement = new StackTraceElement("A", "B", "file", 123);
        String fqcn = "qualified";
        String name = "Ceci n'est pas une pipe";
        String threadName = "threadName";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setContextData(contextData).setContextStack(contextStack).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("qualified").setLoggerName("Ceci n'est pas une pipe").setMarker(marker).setMessage((Message)message).setNanoTime(1234567890L).setSource(stackTraceElement).setThreadName("threadName").setThrown((Throwable)exception).setTimeMillis(987654321L).build();
        Assertions.assertEquals((Object)contextData, (Object)event.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)event.getContextStack());
        Assertions.assertTrue((boolean)event.isEndOfBatch());
        Assertions.assertTrue((boolean)event.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)event.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)event.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)event.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)event.getMarker());
        Assertions.assertSame((Object)message, (Object)event.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)event.getNanoTime());
        Assertions.assertSame((Object)stackTraceElement, (Object)event.getSource());
        Assertions.assertSame((Object)"threadName", (Object)event.getThreadName());
        Assertions.assertSame((Object)exception, (Object)event.getThrown());
        Assertions.assertEquals((long)987654321L, (long)event.getTimeMillis());
        Log4jLogEvent event2 = Log4jLogEventTest.builder((LogEvent)event).build();
        Assertions.assertEquals((Object)event2, (Object)event, (String)"copy constructor builder");
        Assertions.assertEquals((int)event2.hashCode(), (int)event.hashCode(), (String)"same hashCode");
        Assertions.assertEquals((Object)contextData, (Object)event2.getContextData());
        Assertions.assertSame((Object)contextStack, (Object)event2.getContextStack());
        Assertions.assertTrue((boolean)event2.isEndOfBatch());
        Assertions.assertTrue((boolean)event2.isIncludeLocation());
        Assertions.assertSame((Object)Level.FATAL, (Object)event2.getLevel());
        Assertions.assertSame((Object)"qualified", (Object)event2.getLoggerFqcn());
        Assertions.assertSame((Object)"Ceci n'est pas une pipe", (Object)event2.getLoggerName());
        Assertions.assertSame((Object)marker, (Object)event2.getMarker());
        Assertions.assertSame((Object)message, (Object)event2.getMessage());
        Assertions.assertEquals((long)1234567890L, (long)event2.getNanoTime());
        Assertions.assertSame((Object)stackTraceElement, (Object)event2.getSource());
        Assertions.assertSame((Object)"threadName", (Object)event2.getThreadName());
        Assertions.assertSame((Object)exception, (Object)event2.getThrown());
        Assertions.assertEquals((long)987654321L, (long)event2.getTimeMillis());
        StringMap differentMap = ContextDataFactory.emptyFrozenContextData();
        this.different("different contextMap", Log4jLogEventTest.builder((LogEvent)event).setContextData(differentMap), (LogEvent)event);
        this.different("null contextMap", Log4jLogEventTest.builder((LogEvent)event).setContextData(null), (LogEvent)event);
        ThreadContext.push((String)"abc");
        ThreadContext.ContextStack contextStack2 = ThreadContext.getImmutableStack();
        this.different("different contextStack", Log4jLogEventTest.builder((LogEvent)event).setContextStack(contextStack2), (LogEvent)event);
        this.different("null contextStack", Log4jLogEventTest.builder((LogEvent)event).setContextStack(null), (LogEvent)event);
        this.different("different EndOfBatch", Log4jLogEventTest.builder((LogEvent)event).setEndOfBatch(false), (LogEvent)event);
        this.different("different IncludeLocation", Log4jLogEventTest.builder((LogEvent)event).setIncludeLocation(false), (LogEvent)event);
        this.different("different level", Log4jLogEventTest.builder((LogEvent)event).setLevel(Level.INFO), (LogEvent)event);
        this.different("null level", Log4jLogEventTest.builder((LogEvent)event).setLevel(null), (LogEvent)event);
        this.different("different fqcn", Log4jLogEventTest.builder((LogEvent)event).setLoggerFqcn("different"), (LogEvent)event);
        this.different("null fqcn", Log4jLogEventTest.builder((LogEvent)event).setLoggerFqcn(null), (LogEvent)event);
        this.different("different name", Log4jLogEventTest.builder((LogEvent)event).setLoggerName("different"), (LogEvent)event);
        Assertions.assertThrows(NullPointerException.class, () -> this.different("null name", Log4jLogEventTest.builder((LogEvent)event).setLoggerName(null), (LogEvent)event));
        this.different("different marker", Log4jLogEventTest.builder((LogEvent)event).setMarker(MarkerManager.getMarker((String)"different")), (LogEvent)event);
        this.different("null marker", Log4jLogEventTest.builder((LogEvent)event).setMarker(null), (LogEvent)event);
        this.different("different message", Log4jLogEventTest.builder((LogEvent)event).setMessage((Message)new ObjectMessage((Object)"different")), (LogEvent)event);
        Assertions.assertThrows(NullPointerException.class, () -> this.different("null message", Log4jLogEventTest.builder((LogEvent)event).setMessage(null), (LogEvent)event));
        this.different("different nanoTime", Log4jLogEventTest.builder((LogEvent)event).setNanoTime(135L), (LogEvent)event);
        this.different("different milliTime", Log4jLogEventTest.builder((LogEvent)event).setTimeMillis(137L), (LogEvent)event);
        StackTraceElement stack2 = new StackTraceElement("XXX", "YYY", "file", 123);
        this.different("different source", Log4jLogEventTest.builder((LogEvent)event).setSource(stack2), (LogEvent)event);
        this.different("null source", Log4jLogEventTest.builder((LogEvent)event).setSource(null), (LogEvent)event);
        this.different("different threadname", Log4jLogEventTest.builder((LogEvent)event).setThreadName("different"), (LogEvent)event);
        this.different("null threadname", Log4jLogEventTest.builder((LogEvent)event).setThreadName(null), (LogEvent)event);
        this.different("different exception", Log4jLogEventTest.builder((LogEvent)event).setThrown((Throwable)new Error("Boo!")), (LogEvent)event);
        this.different("null exception", Log4jLogEventTest.builder((LogEvent)event).setThrown(null), (LogEvent)event);
    }

    private static Log4jLogEvent.Builder builder(LogEvent event) {
        return new Log4jLogEvent.Builder(event);
    }

    private void different(String reason, Log4jLogEvent.Builder builder, LogEvent event) {
        Log4jLogEvent other = builder.build();
        Assertions.assertNotEquals((Object)other, (Object)event, (String)reason);
        Assertions.assertNotEquals((int)other.hashCode(), (int)event.hashCode(), (String)(reason + " hashCode"));
    }

    @Test
    public void testToString() {
        Assertions.assertNotNull((Object)new Log4jLogEvent().toString());
    }

    public static class FixedTimeClock
    implements Clock {
        public static final long FIXED_TIME = 1234567890L;

        public long currentTimeMillis() {
            return 1234567890L;
        }
    }
}

