/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.TimeFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TimeFilterTest {
    private static long CLOCKTIME = System.currentTimeMillis();

    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j.Clock", FixedTimeClock.class.getName());
    }

    @AfterAll
    public static void afterClass() throws IllegalAccessException {
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void springForward() {
        TimeFilter filter = new TimeFilter(LocalTime.of(2, 0), LocalTime.of(3, 0), ZoneId.of("America/Los_Angeles"), null, null, LocalDate.of(2020, 3, 8));
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ZonedDateTime date = ZonedDateTime.of(2020, 3, 8, 2, 6, 30, 0, ZoneId.of("America/Los_Angeles"));
        CLOCKTIME = date.toInstant().toEpochMilli();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusDays(1L).withHour(2);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.withHour(4);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
    }

    @Test
    public void fallBack() {
        TimeFilter filter = new TimeFilter(LocalTime.of(1, 0), LocalTime.of(2, 0), ZoneId.of("America/Los_Angeles"), null, null, LocalDate.of(2020, 11, 1));
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ZonedDateTime date = ZonedDateTime.of(2020, 11, 1, 1, 6, 30, 0, ZoneId.of("America/Los_Angeles")).withEarlierOffsetAtOverlap();
        CLOCKTIME = date.toInstant().toEpochMilli();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = ZonedDateTime.of(2020, 11, 1, 1, 6, 30, 0, ZoneId.of("America/Los_Angeles")).withLaterOffsetAtOverlap();
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
        date = date.plusDays(1L).withHour(1).withMinute(30);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.withHour(4);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
    }

    @Test
    public void overnight() {
        TimeFilter filter = new TimeFilter(LocalTime.of(23, 0), LocalTime.of(1, 0), ZoneId.of("America/Los_Angeles"), null, null, LocalDate.of(2020, 3, 10));
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ZonedDateTime date = ZonedDateTime.of(2020, 3, 10, 23, 30, 30, 0, ZoneId.of("America/Los_Angeles")).withEarlierOffsetAtOverlap();
        CLOCKTIME = date.toInstant().toEpochMilli();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(1L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(1L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
        date = date.plusDays(1L).withHour(0);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
    }

    @Test
    public void overnightForward() {
        TimeFilter filter = new TimeFilter(LocalTime.of(23, 0), LocalTime.of(2, 0), ZoneId.of("America/Los_Angeles"), null, null, LocalDate.of(2020, 3, 7));
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ZonedDateTime date = ZonedDateTime.of(2020, 3, 7, 23, 30, 30, 0, ZoneId.of("America/Los_Angeles")).withEarlierOffsetAtOverlap();
        CLOCKTIME = date.toInstant().toEpochMilli();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(1L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(2L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
        date = date.plusDays(1L).withHour(0);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
    }

    @Test
    public void overnightFallback() {
        TimeFilter filter = new TimeFilter(LocalTime.of(23, 0), LocalTime.of(2, 0), ZoneId.of("America/Los_Angeles"), null, null, LocalDate.of(2020, 10, 31));
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ZonedDateTime date = ZonedDateTime.of(2020, 10, 31, 23, 30, 30, 0, ZoneId.of("America/Los_Angeles")).withEarlierOffsetAtOverlap();
        CLOCKTIME = date.toInstant().toEpochMilli();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(1L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        date = date.plusHours(2L);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
        date = date.plusDays(1L).withHour(0);
        CLOCKTIME = date.toInstant().toEpochMilli();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
    }

    @Test
    public void testTime() {
        TimeFilter filter = TimeFilter.createFilter((String)"02:00:00", (String)"03:00:00", (String)"America/Los_Angeles", null, null);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles"));
        cal.set(11, 2);
        CLOCKTIME = cal.getTimeInMillis();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        cal.add(5, 1);
        cal.set(11, 2);
        CLOCKTIME = cal.getTimeInMillis();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is not within range: " + filter.toString()));
        cal.set(11, 4);
        CLOCKTIME = cal.getTimeInMillis();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event), (String)("Time " + CLOCKTIME + " is within range: " + filter.toString()));
    }

    public static class FixedTimeClock
    implements Clock {
        public long currentTimeMillis() {
            return CLOCKTIME;
        }
    }
}

