/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class HttpThreadContextMapFilterTest
implements MutableThreadContextMapFilter.FilterConfigUpdateListener {
    private static final String BASIC = "Basic ";
    private static final String expectedCreds = "log4j:log4j";
    private static Server server;
    private static final Base64.Decoder decoder;
    private static int port;
    static final String CONFIG = "log4j2-mutableFilter.xml";
    static LoggerContext loggerContext;
    static final File targetFile;
    static final Path target;
    CountDownLatch updated = new CountDownLatch(1);

    @BeforeAll
    public static void startServer() throws Exception {
        try {
            server = new Server(0);
            ServletContextHandler context = new ServletContextHandler();
            ServletHolder defaultServ = new ServletHolder("default", TestServlet.class);
            defaultServ.setInitParameter("resourceBase", System.getProperty("user.dir"));
            defaultServ.setInitParameter("dirAllowed", "true");
            context.addServlet(defaultServ, "/");
            server.setHandler((Handler)context);
            server.start();
            port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
            try {
                Files.deleteIfExists(target);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    @AfterEach
    public void after() {
        try {
            Files.deleteIfExists(target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loggerContext.stop();
        loggerContext = null;
    }

    @Test
    public void filterTest() throws Exception {
        System.setProperty("log4j2.Configuration.allowedProtocols", "http");
        System.setProperty("logging.auth.username", "log4j");
        System.setProperty("logging.auth.password", "log4j");
        System.setProperty("configLocation", "http://localhost:" + port + "/testConfig.json");
        ThreadContext.put((String)"loginId", (String)"rgoers");
        Path source = new File("target/test-classes/emptyConfig.json").toPath();
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        long fileTime = targetFile.lastModified() - 2000L;
        Assertions.assertTrue((boolean)targetFile.setLastModified(fileTime));
        loggerContext = Configurator.initialize(null, (String)CONFIG);
        Assertions.assertNotNull((Object)loggerContext);
        Appender app = loggerContext.getConfiguration().getAppender("List");
        Assertions.assertNotNull((Object)app);
        Assertions.assertTrue((boolean)(app instanceof ListAppender));
        MutableThreadContextMapFilter filter = (MutableThreadContextMapFilter)loggerContext.getConfiguration().getFilter();
        Assertions.assertNotNull((Object)filter);
        filter.registerListener((MutableThreadContextMapFilter.FilterConfigUpdateListener)this);
        Logger logger = loggerContext.getLogger("Test");
        logger.debug("This is a test");
        Assertions.assertEquals((int)0, (int)((ListAppender)app).getEvents().size());
        source = new File("target/test-classes/filterConfig.json").toPath();
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertNotEquals((long)fileTime, (long)targetFile.lastModified());
        if (!this.updated.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"File update was not detected");
        }
        this.updated = new CountDownLatch(1);
        logger.debug("This is a test");
        Assertions.assertEquals((int)1, (int)((ListAppender)app).getEvents().size());
        Assertions.assertTrue((boolean)Files.deleteIfExists(target));
        if (!this.updated.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"File update for delete was not detected");
        }
    }

    public void onEvent() {
        this.updated.countDown();
    }

    static {
        decoder = Base64.getDecoder();
        loggerContext = null;
        targetFile = new File("target/test-classes/testConfig.json");
        target = targetFile.toPath();
    }

    public static class TestServlet
    extends DefaultServlet {
        private static final long serialVersionUID = -2885158530511450659L;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Enumeration headers = request.getHeaders(HttpHeader.AUTHORIZATION.toString());
            if (headers == null) {
                response.sendError(401, "No Auth header");
                return;
            }
            while (headers.hasMoreElements()) {
                String authData = (String)headers.nextElement();
                Assert.assertTrue((String)"Not a Basic auth header", (boolean)authData.startsWith(HttpThreadContextMapFilterTest.BASIC));
                String credentials = new String(decoder.decode(authData.substring(HttpThreadContextMapFilterTest.BASIC.length())));
                if (HttpThreadContextMapFilterTest.expectedCreds.equals(credentials)) continue;
                response.sendError(401, "Invalid credentials");
                return;
            }
            if (request.getServletPath().equals("/testConfig.json")) {
                File file = new File("target/test-classes/testConfig.json");
                if (!file.exists()) {
                    response.sendError(404, "File not found");
                    return;
                }
                long modifiedSince = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString());
                long lastModified = file.lastModified() / 1000L * 1000L;
                if (modifiedSince > 0L && lastModified <= modifiedSince) {
                    response.setStatus(304);
                    return;
                }
                response.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), lastModified);
                response.setContentLengthLong(file.length());
                Files.copy(file.toPath(), (OutputStream)response.getOutputStream());
                response.getOutputStream().flush();
                response.setStatus(200);
            } else {
                response.sendError(400, "Unsupported request");
            }
        }
    }
}

