/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="missingRootLogger.xml")
public class MissingRootLoggerTest {
    @Test
    public void testMissingRootLogger(LoggerContext ctx) throws Exception {
        Logger logger = ctx.getLogger("sample.Logger1");
        Assertions.assertTrue((boolean)logger.isInfoEnabled(), (String)"Logger should have the INFO level enabled");
        Assertions.assertFalse((boolean)logger.isDebugEnabled(), (String)"Logger should have the DEBUG level disabled");
        Configuration config = ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"Config not null");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders not null");
        MatcherAssert.assertThat((String)"There should only be two appenders", (Object)map, MapMatchers.hasSize(2));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"DefaultConsole-2"));
        Map loggerMap = config.getLoggers();
        Assertions.assertNotNull((Object)loggerMap, (String)"loggerMap not null");
        MatcherAssert.assertThat((String)"There should only be one configured logger", (Object)loggerMap, MapMatchers.hasSize(1));
        MatcherAssert.assertThat((String)"contains key=sample", (Object)loggerMap, (Matcher)Matchers.hasKey((Object)"sample"));
        LoggerConfig sample = (LoggerConfig)loggerMap.get("sample");
        Map sampleAppenders = sample.getAppenders();
        MatcherAssert.assertThat((String)"The sample logger should only have one appender", (Object)sampleAppenders, MapMatchers.hasSize(1));
        MatcherAssert.assertThat((String)"The sample appender should be a ListAppender", (Object)sampleAppenders, (Matcher)Matchers.hasKey((Object)"List"));
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(AbstractConfiguration.class)));
        AbstractConfiguration baseConfig = (AbstractConfiguration)config;
        LoggerConfig root = baseConfig.getRootLogger();
        Map rootAppenders = root.getAppenders();
        MatcherAssert.assertThat((String)"The root logger should only have one appender", (Object)rootAppenders, MapMatchers.hasSize(1));
        MatcherAssert.assertThat((String)"The root appender should be a ConsoleAppender", (Object)rootAppenders, (Matcher)Matchers.hasKey((Object)"DefaultConsole-2"));
        Assertions.assertEquals((Object)Level.ERROR, (Object)root.getLevel());
    }
}

