/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.async.QueueFullAbstractTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class QueueFullAsyncLoggerConfigLoggingFromToStringTest
extends QueueFullAbstractTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-queueFullAsyncLoggerConfig.xml");

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("AsyncLoggerConfig.RingBufferSize", "128");
        System.setProperty("log4j.configurationFile", "log4j2-queueFullAsyncLoggerConfig.xml");
    }

    @Before
    public void before() throws Exception {
        this.blockingAppender = this.context.getRequiredAppender("Blocking", BlockingAppender.class);
    }

    @Test(timeout=5000L)
    public void testLoggingFromToStringCausesOutOfOrderMessages() throws InterruptedException {
        Logger logger = LogManager.getLogger(this.getClass());
        this.blockingAppender.countDownLatch = new CountDownLatch(1);
        this.unlocker = new QueueFullAbstractTest.Unlocker(this, new CountDownLatch(129));
        this.unlocker.start();
        QueueFullAsyncLoggerConfigLoggingFromToStringTest.asyncLoggerConfigRecursiveTest(logger, this.unlocker, this.blockingAppender, this);
    }

    static void asyncLoggerConfigRecursiveTest(Logger logger, QueueFullAbstractTest.Unlocker unlocker, BlockingAppender blockingAppender, QueueFullAbstractTest factory) {
        for (int i = 0; i < 1; ++i) {
            QueueFullAsyncLoggerConfigLoggingFromToStringTest.TRACE("Test logging message " + i + ". Remaining capacity=" + QueueFullAsyncLoggerConfigLoggingFromToStringTest.asyncRemainingCapacity(logger));
            QueueFullAsyncLoggerConfigLoggingFromToStringTest.TRACE("Test decrementing unlocker countdown latch. Count=" + unlocker.countDownLatch.getCount());
            unlocker.countDownLatch.countDown();
            QueueFullAbstractTest queueFullAbstractTest = factory;
            queueFullAbstractTest.getClass();
            QueueFullAbstractTest.DomainObject obj = new QueueFullAbstractTest.DomainObject(queueFullAbstractTest, 129);
            logger.info("logging naughty object #{} {}", (Object)i, (Object)obj);
        }
        QueueFullAsyncLoggerConfigLoggingFromToStringTest.TRACE("Before stop() blockingAppender.logEvents.count=" + blockingAppender.logEvents.size());
        while (blockingAppender.logEvents.size() < 130) {
            Thread.yield();
        }
        QueueFullAsyncLoggerConfigLoggingFromToStringTest.TRACE("After  stop() blockingAppender.logEvents.count=" + blockingAppender.logEvents.size());
        Stack<String> actual = QueueFullAsyncLoggerConfigLoggingFromToStringTest.transform(blockingAppender.logEvents);
        Assert.assertEquals((Object)"Logging in toString() #0", (Object)actual.pop());
        List statusDataList = StatusLogger.getLogger().getStatusData();
        Assert.assertEquals((String)"Jumped the queue: queue full", (Object)"Logging in toString() #128", (Object)actual.pop());
        StatusData mostRecentStatusData = (StatusData)statusDataList.get(statusDataList.size() - 1);
        Assert.assertEquals((String)"Expected warn level status message", (Object)Level.WARN, (Object)mostRecentStatusData.getLevel());
        Assert.assertThat((Object)mostRecentStatusData.getFormattedStatus(), (Matcher)StringContains.containsString((String)"Log4j2 logged an event out of order to prevent deadlock caused by domain objects logging from their toString method when the async queue is full"));
        for (int i = 1; i < 128; ++i) {
            Assert.assertEquals((String)"First batch", (Object)("Logging in toString() #" + i), (Object)actual.pop());
        }
        Assert.assertEquals((Object)"logging naughty object #0 Who's bad?!", (Object)actual.pop());
        Assert.assertTrue((boolean)actual.isEmpty());
    }
}

