/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.dsl.Disruptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;

public abstract class QueueFullAbstractTest {
    protected static boolean TRACE = Boolean.getBoolean(QueueFullAbstractTest.class.getSimpleName() + ".TRACE");
    protected BlockingAppender blockingAppender;
    protected Unlocker unlocker;

    protected static void TRACE(Object msg) {
        if (TRACE) {
            System.out.println(msg);
        }
    }

    static Stack<String> transform(List<LogEvent> logEvents) {
        ArrayList<String> filtered = new ArrayList<String>(logEvents.size());
        for (LogEvent event : logEvents) {
            filtered.add(event.getMessage().getFormattedMessage());
        }
        Collections.reverse(filtered);
        Stack<String> result = new Stack<String>();
        result.addAll(filtered);
        return result;
    }

    static long asyncRemainingCapacity(Logger logger) {
        if (logger instanceof AsyncLogger) {
            try {
                Field f = QueueFullAbstractTest.field(AsyncLogger.class, "loggerDisruptor");
                return ((AsyncLoggerDisruptor)f.get(logger)).getDisruptor().getRingBuffer().remainingCapacity();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        LoggerConfig loggerConfig = ((org.apache.logging.log4j.core.Logger)logger).get();
        if (loggerConfig instanceof AsyncLoggerConfig) {
            try {
                Object delegate = QueueFullAbstractTest.field(AsyncLoggerConfig.class, "delegate").get(loggerConfig);
                return ((Disruptor)QueueFullAbstractTest.field(AsyncLoggerConfigDisruptor.class, "disruptor").get(delegate)).getRingBuffer().remainingCapacity();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        Appender async = (Appender)loggerConfig.getAppenders().get("async");
        if (async instanceof AsyncAppender) {
            return ((AsyncAppender)async).getQueueCapacity();
        }
        throw new IllegalStateException("Neither Async Loggers nor AsyncAppender are configured");
    }

    private static Field field(Class<?> c, String name) throws NoSuchFieldException {
        Field f = c.getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    class DomainObject {
        private final Logger innerLogger = LogManager.getLogger(DomainObject.class);
        final int count;

        DomainObject(int loggingCount) {
            this.count = loggingCount;
        }

        public String toString() {
            for (int i = 0; i < this.count; ++i) {
                QueueFullAbstractTest.TRACE("DomainObject decrementing unlocker countdown latch before logging. Count was " + QueueFullAbstractTest.this.unlocker.countDownLatch.getCount());
                QueueFullAbstractTest.this.unlocker.countDownLatch.countDown();
                QueueFullAbstractTest.TRACE("DomainObject logging message " + i + ". Remaining capacity=" + QueueFullAbstractTest.asyncRemainingCapacity(this.innerLogger));
                this.innerLogger.info("Logging in toString() #" + i);
            }
            return "Who's bad?!";
        }
    }

    class Unlocker
    extends Thread {
        final CountDownLatch countDownLatch;

        Unlocker(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                this.countDownLatch.await();
                QueueFullAbstractTest.TRACE("Unlocker activated. Sleeping 500 millis before taking action...");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            QueueFullAbstractTest.TRACE("Unlocker signalling BlockingAppender to proceed...");
            QueueFullAbstractTest.this.blockingAppender.countDownLatch.countDown();
        }
    }
}

