/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class DiscardingAsyncQueueFullPolicyTest {
    private static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    private static long otherThreadId() {
        return -1L;
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNullThresholdLevel() {
        new DiscardingAsyncQueueFullPolicy(null);
    }

    @Test
    public void testThresholdLevelIsConstructorValue() {
        Assert.assertSame((Object)Level.ALL, (Object)new DiscardingAsyncQueueFullPolicy(Level.ALL).getThresholdLevel());
        Assert.assertSame((Object)Level.OFF, (Object)new DiscardingAsyncQueueFullPolicy(Level.OFF).getThresholdLevel());
        Assert.assertSame((Object)Level.INFO, (Object)new DiscardingAsyncQueueFullPolicy(Level.INFO).getThresholdLevel());
    }

    @Test
    public void testGetRouteDiscardsIfThresholdCapacityReachedAndLevelEqualOrLessSpecificThanThreshold() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.WARN);
        for (Level level : new Level[]{Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL}) {
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
        }
    }

    @Test
    public void testGetRouteDiscardsIfQueueFullAndLevelEqualOrLessSpecificThanThreshold() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.WARN);
        for (Level level : new Level[]{Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL}) {
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.DISCARD, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
        }
    }

    @Test
    public void testGetRouteEnqueuesIfThresholdCapacityReachedButLevelMoreSpecificThanThreshold() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.WARN);
        for (Level level : new Level[]{Level.ERROR, Level.FATAL, Level.OFF}) {
            Assert.assertEquals((String)level.name(), (Object)EventRoute.SYNCHRONOUS, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.ENQUEUE, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.SYNCHRONOUS, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
            Assert.assertEquals((String)level.name(), (Object)EventRoute.ENQUEUE, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
        }
    }

    @Test
    public void testGetRouteEnqueueIfOtherThreadQueueFullAndLevelMoreSpecificThanThreshold() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.WARN);
        for (Level level : new Level[]{Level.ERROR, Level.FATAL, Level.OFF}) {
            Assert.assertEquals((String)level.name(), (Object)EventRoute.ENQUEUE, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.otherThreadId(), level));
        }
    }

    @Test
    public void testGetRouteSynchronousIfCurrentThreadQueueFullAndLevelMoreSpecificThanThreshold() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.WARN);
        for (Level level : new Level[]{Level.ERROR, Level.FATAL, Level.OFF}) {
            Assert.assertEquals((String)level.name(), (Object)EventRoute.SYNCHRONOUS, (Object)router.getRoute(DiscardingAsyncQueueFullPolicyTest.currentThreadId(), level));
        }
    }

    @Test
    public void testGetDiscardCount() throws Exception {
        DiscardingAsyncQueueFullPolicy router = new DiscardingAsyncQueueFullPolicy(Level.INFO);
        Assert.assertEquals((String)"initially", (long)0L, (long)DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)router));
        Assert.assertEquals((Object)EventRoute.DISCARD, (Object)router.getRoute(-1L, Level.INFO));
        Assert.assertEquals((String)"increase", (long)1L, (long)DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)router));
        Assert.assertEquals((Object)EventRoute.DISCARD, (Object)router.getRoute(-1L, Level.INFO));
        Assert.assertEquals((String)"increase", (long)2L, (long)DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)router));
        Assert.assertEquals((Object)EventRoute.DISCARD, (Object)router.getRoute(-1L, Level.INFO));
        Assert.assertEquals((String)"increase", (long)3L, (long)DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)router));
    }
}

