/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.junit.StatusLoggerLevel;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@StatusLoggerLevel(value="WARN")
public class AbstractActionTest {
    @Test
    public void testExceptionsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new TestAction().run();
        List statusDataList = statusLogger.getStatusData();
        MatcherAssert.assertThat((Object)statusDataList, (Matcher)Matchers.hasSize((int)1));
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assertions.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        MatcherAssert.assertThat((Object)formattedMessage, (Matcher)Matchers.containsString((String)("Exception reported by action 'class org.apache.logging.log4j.core.appender.rolling.action.AbstractActionTest$TestAction' java.io.IOException: failed" + System.lineSeparator() + "\tat org.apache.logging.log4j.core.appender.rolling.action.AbstractActionTest$TestAction.execute(AbstractActionTest.java:")));
    }

    @Test
    public void testRuntimeExceptionsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new AbstractAction(){

            public boolean execute() {
                throw new IllegalStateException();
            }
        }.run();
        List statusDataList = statusLogger.getStatusData();
        MatcherAssert.assertThat((Object)statusDataList, (Matcher)Matchers.hasSize((int)1));
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assertions.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        MatcherAssert.assertThat((Object)formattedMessage, (Matcher)Matchers.containsString((String)"Exception reported by action"));
    }

    @Test
    public void testErrorsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new AbstractAction(){

            public boolean execute() {
                throw new AssertionError();
            }
        }.run();
        List statusDataList = statusLogger.getStatusData();
        MatcherAssert.assertThat((Object)statusDataList, (Matcher)Matchers.hasSize((int)1));
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assertions.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        MatcherAssert.assertThat((Object)formattedMessage, (Matcher)Matchers.containsString((String)"Exception reported by action"));
    }

    private static final class TestAction
    extends AbstractAction {
        private TestAction() {
        }

        public boolean execute() throws IOException {
            throw new IOException("failed");
        }
    }
}

