/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.time.LocalTime;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.CleanUpDirectories;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@CleanUpDirectories(value={"target/rolling-random-direct-switch-director"})
public class RollingRandomAppenderDirectWriteAndSwitchDirectorTest {
    public static final String DIR = "target/rolling-random-direct-switch-director";

    @Test
    @LoggerContextSource(value="log4j-rolling-random-direct-switch-director.xml", timeout=10L)
    public void testAppender(LoggerContext context) throws Exception {
        LocalTime end;
        Logger logger = context.getLogger(RollingRandomAppenderDirectWriteAndSwitchDirectorTest.class.getName());
        LocalTime start = LocalTime.now();
        do {
            end = LocalTime.now();
            logger.info("test log");
            Thread.sleep(100L);
        } while (start.getSecond() == end.getSecond());
        File nextLogFile = new File(String.format("%s/%d/%d.log", DIR, end.getSecond(), end.getSecond()));
        Assertions.assertTrue((boolean)nextLogFile.exists(), (String)"nextLogFile not created");
    }
}

