/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.FormattingInfo;
import org.apache.logging.log4j.core.pattern.IntegerPatternConverter;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingAppenderSizeMaxWidthTest
implements RolloverListener {
    private static final String DIR = "target/rolling-max-width/archive";
    private static final String MESSAGE = "This is test message number ";
    private static final int COUNT = 10000;
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public LoggerContextRule loggerContextRule;
    @Rule
    public RuleChain chain;
    List<String> rolledFileNames = new ArrayList<String>();
    int min;
    int max;
    boolean isZeroPad;
    int minWidth;
    int maxWidth;
    long rolloverSize;
    private Logger logger;
    private int rolloverCount = 0;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new LoggerContextRule("log4j-rolling-size-max-width-1.xml")}, {new LoggerContextRule("log4j-rolling-size-max-width-2.xml")}, {new LoggerContextRule("log4j-rolling-size-max-width-3.xml")}, {new LoggerContextRule("log4j-rolling-size-max-width-4.xml")});
    }

    private static int powerOfTen(int pow) {
        if (pow > POWERS_OF_10.length) {
            throw new IllegalArgumentException("Max width is too large");
        }
        return POWERS_OF_10[pow];
    }

    public RollingAppenderSizeMaxWidthTest(LoggerContextRule loggerContextRule) {
        this.loggerContextRule = loggerContextRule;
        this.chain = loggerContextRule.withCleanFoldersRule(DIR);
    }

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger(RollingAppenderSizeMaxWidthTest.class.getName());
        RollingFileAppender app = (RollingFileAppender)this.loggerContextRule.getRequiredAppender("RollingFile");
        ((RollingFileManager)app.getManager()).addRolloverListener((RolloverListener)this);
        ArrayPatternConverter[] patternConverters = ((RollingFileManager)app.getManager()).getPatternProcessor().getPatternConverters();
        int index = IntStream.range(0, patternConverters.length).filter(i -> patternConverters[i] instanceof IntegerPatternConverter).findFirst().orElse(-1);
        if (index < 0) {
            Assert.fail((String)("Could not find integer pattern converter in " + app.getFilePattern()));
        }
        FormattingInfo formattingInfo = ((RollingFileManager)app.getManager()).getPatternProcessor().getPatternFields()[index];
        this.minWidth = formattingInfo.getMinLength();
        this.maxWidth = formattingInfo.getMaxLength();
        this.isZeroPad = formattingInfo.isZeroPad();
        DefaultRolloverStrategy strategy = (DefaultRolloverStrategy)((RollingFileManager)app.getManager()).getRolloverStrategy();
        this.min = strategy.getMinIndex();
        this.max = strategy.getMaxIndex();
        SizeBasedTriggeringPolicy policy = app.getTriggeringPolicy() instanceof CompositeTriggeringPolicy ? (SizeBasedTriggeringPolicy)Arrays.stream(((CompositeTriggeringPolicy)app.getTriggeringPolicy()).getTriggeringPolicies()).filter(p -> p instanceof SizeBasedTriggeringPolicy).findFirst().orElse(null) : (SizeBasedTriggeringPolicy)app.getTriggeringPolicy();
        Assert.assertNotNull((String)"No SizeBasedTriggeringPolicy", (Object)policy);
        this.rolloverSize = policy.getMaxFileSize();
    }

    @Test
    public void testAppender() throws Exception {
        if (this.minWidth > 0) {
            Assert.assertTrue((String)"min must be greater than or equal to the minimum width", (this.min > -RollingAppenderSizeMaxWidthTest.powerOfTen(this.minWidth) ? 1 : 0) != 0);
        }
        if (this.maxWidth < Integer.MAX_VALUE) {
            Assert.assertTrue((String)"max must be less than or equal to the maximum width", (this.max <= RollingAppenderSizeMaxWidthTest.powerOfTen(this.maxWidth) ? 1 : 0) != 0);
        }
        long bytes = 0L;
        for (int i = 0; i < 10000; ++i) {
            String message = MESSAGE + i;
            this.logger.debug(message);
            bytes += (long)(message.length() + 1);
        }
        long minExpected = bytes / this.rolloverSize * 95L / 100L;
        long maxExpected = bytes / this.rolloverSize * 105L / 100L;
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertTrue((String)("Not enough rollovers: expected: " + minExpected + ", actual: " + this.rolloverCount), ((long)(this.rolloverCount + 1) >= minExpected ? 1 : 0) != 0);
        Assert.assertTrue((String)("Too many rollovers: expected: " + maxExpected + ", actual: " + this.rolloverCount), ((long)this.rolloverCount <= maxExpected ? 1 : 0) != 0);
        int maxFiles = this.max - this.min + 1;
        int maxExpectedFiles = Math.min(maxFiles, this.rolloverCount);
        Assert.assertEquals((String)("More files than expected. expected: " + maxExpectedFiles + ", actual: " + files.length), (long)maxExpectedFiles, (long)files.length);
    }

    public void rolloverTriggered(String fileName) {
        ++this.rolloverCount;
    }

    public void rolloverComplete(String fileName) {
        this.rolledFileNames.add(fileName);
    }
}

