/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore(value="https://issues.apache.org/jira/browse/LOG4J2-3522")
public class RollingAppenderCountTest {
    private static final String SOURCE = "src/test/resources/__files";
    private static final String DIR = "target/rolling_count";
    private static final String CONFIG = "log4j-rolling-count.xml";
    private static final String FILENAME = "onStartup.log";
    private static final String TARGET = "rolling_test.log.";
    private Logger logger;
    @Rule
    public LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-count.xml");

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger("LogTest");
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        File dir;
        if (Files.exists(Paths.get(DIR, new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
                Files.delete(Paths.get(DIR, new String[0]));
            }
        }
        if (!(dir = new File(DIR)).exists()) {
            Files.createDirectory(new File(DIR).toPath(), new FileAttribute[0]);
        }
        Path target = Paths.get(DIR, TARGET + System.currentTimeMillis());
        Files.copy(Paths.get(SOURCE, FILENAME), target, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        int count = Objects.requireNonNull(new File(DIR).listFiles()).length;
        Assert.assertEquals((String)("Expected 17 files, got " + count), (long)17L, (long)count);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
            for (Path path : directoryStream) {
                Files.delete(path);
            }
        }
        Files.delete(Paths.get(DIR, new String[0]));
    }

    @Test
    public void testLog() throws Exception {
        for (long i = 0L; i < 60L; ++i) {
            this.logger.info("Sequence: " + i);
            this.logger.debug(RandomStringUtils.randomAscii((int)128, (int)512));
            Thread.sleep(250L);
        }
    }
}

