/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.SocketAppenderTest;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SocketAppenderBufferSizeTest {
    private SocketAppenderTest.TcpSocketTestServer tcpServer;
    private LoggerContext loggerContext;
    private Logger logger;
    @Rule
    public LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-empty.xml");

    @Before
    public void setup() throws Exception {
        this.tcpServer = new SocketAppenderTest.TcpSocketTestServer(AvailablePortFinder.getNextAvailable());
        this.tcpServer.start();
        ThreadContext.clearAll();
        this.loggerContext = this.loggerContextRule.getLoggerContext();
        this.logger = this.loggerContext.getLogger(SocketAppenderBufferSizeTest.class.getName());
    }

    @After
    public void teardown() {
        this.tcpServer.shutdown();
        this.loggerContext = null;
        this.logger = null;
        this.tcpServer.reset();
        ThreadContext.clearAll();
    }

    @Test
    public void testTcpAppenderDefaultEncoderBufferSize() throws Exception {
        SocketAppenderTest.testTcpAppender(this.tcpServer, this.logger, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    @Test
    public void testTcpAppenderLargeEncoderBufferSize() throws Exception {
        SocketAppenderTest.testTcpAppender(this.tcpServer, this.logger, Constants.ENCODER_BYTE_BUFFER_SIZE * 100);
    }

    @Test
    public void testTcpAppenderSmallestEncoderBufferSize() throws Exception {
        SocketAppenderTest.testTcpAppender(this.tcpServer, this.logger, 1);
    }
}

