/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class RandomAccessFileManagerTest {
    @TempDir
    File tempDir;

    @Test
    public void testWrite_multiplesOfBufferSize() throws IOException {
        File file = new File(this.tempDir, "testWrite_multiplesOfBufferSize.bin");
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 262144, null, null, true);
            int size = 786432;
            byte[] data = new byte[786432];
            manager.write(data);
            Assertions.assertEquals((long)786432L, (long)raf.length());
        }
    }

    @Test
    public void testWrite_dataExceedingBufferSize() throws IOException {
        File file = new File(this.tempDir, "testWrite_dataExceedingBufferSize.bin");
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 262144, null, null, true);
            int size = 786433;
            byte[] data = new byte[786433];
            manager.write(data);
            Assertions.assertEquals((long)786433L, (long)raf.length());
            manager.flush();
            Assertions.assertEquals((long)786433L, (long)raf.length());
        }
    }

    @Test
    public void testConfigurableBufferSize() throws IOException {
        File file = new File(this.tempDir, "testConfigurableBufferSize.bin");
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            int bufferSize = 4096;
            Assertions.assertNotEquals((int)4096, (int)262144);
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 4096, null, null, true);
            Assertions.assertEquals((int)4096, (int)manager.getBufferSize());
        }
    }

    @Test
    public void testWrite_dataExceedingMinBufferSize() throws IOException {
        File file = new File(this.tempDir, "testWrite_dataExceedingMinBufferSize.bin");
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            boolean bufferSize = true;
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 1, null, null, true);
            int size = 4;
            byte[] data = new byte[4];
            manager.write(data);
            Assertions.assertEquals((long)4L, (long)raf.length());
            manager.flush();
            Assertions.assertEquals((long)4L, (long)raf.length());
        }
    }

    @Test
    public void testAppendDoesNotOverwriteExistingFile() throws IOException {
        boolean isAppend = true;
        File file = new File(this.tempDir, "testAppendDoesNotOverwriteExistingFile.bin");
        Assertions.assertEquals((long)0L, (long)file.length());
        byte[] bytes = new byte[4096];
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes, 0, bytes.length);
            fos.flush();
        }
        Assertions.assertEquals((long)bytes.length, (long)file.length(), (String)"all flushed to disk");
        var5_5 = null;
        try (RandomAccessFileManager manager = RandomAccessFileManager.getFileManager((String)file.getAbsolutePath(), (boolean)true, (boolean)true, (int)262144, null, null, null);){
            manager.write(bytes, 0, bytes.length, true);
            int expected = bytes.length * 2;
            Assertions.assertEquals((long)expected, (long)file.length(), (String)"appended, not overwritten");
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }
}

